/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.network.ext.LbMethod;
import org.openstack4j.model.network.ext.LbPool;
import org.openstack4j.model.network.ext.Protocol;
import org.openstack4j.model.network.ext.builder.LbPoolBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="pool")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronLbPool
implements LbPool {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="health_monitors")
    private List<String> healthMonitors;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="vip_id")
    private String vipId;
    private String name;
    private String description;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    private Protocol protocol;
    private String provider;
    @JsonProperty(value="lb_method")
    private LbMethod lbMethod;
    private List<String> members;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    private String status;

    public static LbPoolBuilder builder() {
        return new LbPoolContreteBuilder();
    }

    @Override
    public LbPoolBuilder toBuilder() {
        return new LbPoolContreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getVipId() {
        return this.vipId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public LbMethod getLbMethod() {
        return this.lbMethod;
    }

    @Override
    public List<String> getMembers() {
        return this.members;
    }

    @Override
    public List<String> getHealthMonitors() {
        return this.healthMonitors;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("adminStateUp", this.adminStateUp).add("description", this.description).add("healthMonitors", this.healthMonitors).add("lbMethod", (Object)this.lbMethod).add("members", this.members).add("name", this.name).add("protocol", (Object)this.protocol).add("provider", this.provider).add("status", this.status).add("subnetId", this.subnetId).add("tenantId", this.tenantId).add("vipId", this.vipId).toString();
    }

    public static class LbPools
    extends ListResult<NeutronLbPool> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="pools")
        List<NeutronLbPool> lbPools;

        @Override
        public List<NeutronLbPool> value() {
            return this.lbPools;
        }

        public String toString() {
            return new ToStringHelper(this).add("lbPools", this.lbPools).toString();
        }
    }

    public static class LbPoolContreteBuilder
    implements LbPoolBuilder {
        private NeutronLbPool m;

        public LbPoolContreteBuilder() {
            this(new NeutronLbPool());
        }

        public LbPoolContreteBuilder(NeutronLbPool m) {
            this.m = m;
        }

        @Override
        public LbPool build() {
            return this.m;
        }

        @Override
        public LbPoolBuilder from(LbPool in) {
            this.m = (NeutronLbPool)in;
            return this;
        }

        @Override
        public LbPoolBuilder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public LbPoolBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public LbPoolBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public LbPoolBuilder subnetId(String subnentId) {
            this.m.subnetId = subnentId;
            return this;
        }

        @Override
        public LbPoolBuilder provider(String provider) {
            this.m.provider = provider;
            return this;
        }

        @Override
        public LbPoolBuilder lbMethod(LbMethod lbMethod) {
            this.m.lbMethod = lbMethod;
            return this;
        }

        @Override
        public LbPoolBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public LbPoolBuilder protocol(Protocol protocol) {
            this.m.protocol = protocol;
            return this;
        }
    }
}

