/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.network.ext.NetQosPolicyBandwidthLimitRule;
import org.openstack4j.model.network.ext.builder.NetQosPolicyBandwidthLimitRuleBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.ext.NeutronNetQosPolicyRuleTag;

@JsonRootName(value="bandwidth_limit_rule")
public class NeutronNetQosPolicyBandwidthLimitRule
implements NetQosPolicyBandwidthLimitRule {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty(value="max_kbps")
    private Integer maxKbps;
    @JsonProperty(value="max_burst_kbps")
    private Integer maxBurstKbps;
    @JsonProperty
    private NetQosPolicyBandwidthLimitRule.Direction direction;
    @JsonProperty
    private NeutronNetQosPolicyRuleTag tags;

    public static NetQosPolicyBandwidthLimitRuleBuilder builder() {
        return new NetQosPolicyBandwidthLimitRuleConcreteBuilder();
    }

    @Override
    public NetQosPolicyBandwidthLimitRuleBuilder toBuilder() {
        return new NetQosPolicyBandwidthLimitRuleConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Integer getMaxKbps() {
        return this.maxKbps;
    }

    @Override
    public Integer getMaxBurstKbps() {
        return this.maxBurstKbps;
    }

    @Override
    public NetQosPolicyBandwidthLimitRule.Direction getDirection() {
        return this.direction;
    }

    @Override
    @JsonIgnore
    public String getDirectionValue() {
        return this.direction == null ? null : this.direction.name();
    }

    @Override
    public NeutronNetQosPolicyRuleTag getTags() {
        return this.tags;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("maxKbps", (Object)this.maxKbps).add("maxBurstKbps", (Object)this.maxBurstKbps).add("direction", (Object)this.direction).add("tags", (Object)this.tags).toString();
    }

    public static class NeutronNetQosPolicyBLRules
    extends ListResult<NeutronNetQosPolicyBandwidthLimitRule> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="bandwidth_limit_rules")
        private List<NeutronNetQosPolicyBandwidthLimitRule> bandwidthLimitRules;

        @Override
        protected List<NeutronNetQosPolicyBandwidthLimitRule> value() {
            return this.bandwidthLimitRules;
        }
    }

    public static class NetQosPolicyBandwidthLimitRuleConcreteBuilder
    implements NetQosPolicyBandwidthLimitRuleBuilder {
        private NeutronNetQosPolicyBandwidthLimitRule model;

        public NetQosPolicyBandwidthLimitRuleConcreteBuilder() {
            this.model = new NeutronNetQosPolicyBandwidthLimitRule();
        }

        public NetQosPolicyBandwidthLimitRuleConcreteBuilder(NeutronNetQosPolicyBandwidthLimitRule model) {
            this.model = model;
        }

        @Override
        public NetQosPolicyBandwidthLimitRule build() {
            return this.model;
        }

        @Override
        public NetQosPolicyBandwidthLimitRuleBuilder from(NetQosPolicyBandwidthLimitRule in) {
            this.model = (NeutronNetQosPolicyBandwidthLimitRule)in;
            return this;
        }

        @Override
        public NetQosPolicyBandwidthLimitRuleBuilder maxKbps(Integer maxKbps) {
            this.model.maxKbps = maxKbps;
            return this;
        }

        @Override
        public NetQosPolicyBandwidthLimitRuleBuilder maxBurstKbps(Integer maxBurstKbps) {
            this.model.maxBurstKbps = maxBurstKbps;
            return this;
        }

        @Override
        public NetQosPolicyBandwidthLimitRuleBuilder direction(NetQosPolicyBandwidthLimitRule.Direction direction) {
            this.model.direction = direction;
            return this;
        }
    }
}

