/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openstack4j.model.network.ext.NetworkIPAvailability;
import org.openstack4j.model.network.ext.SubnetIPAvailability;
import org.openstack4j.model.network.ext.builder.NetworkIPAvailabilityBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.ext.NeutronSubnetIPAvailability;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="network_ip_availability")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronNetworkIPAvailability
implements NetworkIPAvailability {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="network_name")
    private String networkName;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="used_ips")
    private BigInteger usedIps;
    @JsonProperty(value="total_ips")
    private BigInteger totalIps;
    @JsonProperty(value="subnet_ip_availability")
    private List<NeutronSubnetIPAvailability> subnetIPAvailabilities;

    public NeutronNetworkIPAvailability() {
    }

    public NeutronNetworkIPAvailability(String networkName, String networkId, String tenantId, String projectId, BigInteger usedIps, BigInteger totalIps, List<NeutronSubnetIPAvailability> subnetIPAvailabilities) {
        this.networkName = networkName;
        this.networkId = networkId;
        this.tenantId = tenantId;
        this.projectId = projectId;
        this.usedIps = usedIps;
        this.totalIps = totalIps;
        this.subnetIPAvailabilities = subnetIPAvailabilities;
    }

    public static NetworkIPAvailabilityBuilder builder() {
        return new NetworkIPAvailabilityConcreteBuilder();
    }

    @Override
    public NetworkIPAvailabilityBuilder toBuilder() {
        return new NetworkIPAvailabilityConcreteBuilder(this);
    }

    @Override
    public String getNetworkName() {
        return this.networkName;
    }

    @Override
    public String getNetworkId() {
        return this.networkId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public BigInteger getTotalIps() {
        return this.totalIps;
    }

    @Override
    public BigInteger getUsedIps() {
        return this.usedIps;
    }

    @Override
    public List<? extends SubnetIPAvailability> getSubnetIPAvailabilities() {
        return this.subnetIPAvailabilities;
    }

    public String toString() {
        return new ToStringHelper(this).add("networkName", this.networkName).add("networkId", this.networkId).add("tenantId", this.tenantId).add("projectId", this.projectId).add("usedIps", this.usedIps).add("totalIps", this.totalIps).add("subnetIPAvailabilities", this.subnetIPAvailabilities).toString();
    }

    public static class NeutronNetworkIPAvailabilities
    extends ListResult<NeutronNetworkIPAvailability> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="network_ip_availabilities")
        private List<NeutronNetworkIPAvailability> networkIPAvailabilities;

        @Override
        protected List<NeutronNetworkIPAvailability> value() {
            return this.networkIPAvailabilities;
        }
    }

    public static class NetworkIPAvailabilityConcreteBuilder
    implements NetworkIPAvailabilityBuilder {
        private NeutronNetworkIPAvailability model;

        public NetworkIPAvailabilityConcreteBuilder() {
            this.model = new NeutronNetworkIPAvailability();
        }

        public NetworkIPAvailabilityConcreteBuilder(NeutronNetworkIPAvailability model) {
            this.model = model;
        }

        @Override
        public NetworkIPAvailability build() {
            return this.model;
        }

        @Override
        public NetworkIPAvailabilityBuilder from(NetworkIPAvailability in) {
            this.model = (NeutronNetworkIPAvailability)in;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder networkName(String networkName) {
            this.model.networkName = networkName;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder networkId(String networkId) {
            this.model.networkId = networkId;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder projectId(String projectId) {
            this.model.projectId = projectId;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder totalIps(BigInteger totalIps) {
            this.model.totalIps = totalIps;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder usedIps(BigInteger usedIps) {
            this.model.usedIps = usedIps;
            return this;
        }

        @Override
        public NetworkIPAvailabilityBuilder subnetIPAvailability(SubnetIPAvailability subnetIPAvailability) {
            if (this.model.subnetIPAvailabilities == null) {
                this.model.subnetIPAvailabilities = new ArrayList();
            }
            this.model.subnetIPAvailabilities.add((NeutronSubnetIPAvailability)subnetIPAvailability);
            return this;
        }
    }
}

