/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.Apis;
import org.openstack4j.api.networking.NetFloatingIPService;
import org.openstack4j.api.networking.ext.PortForwardingService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.NeutronFloatingIP;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class FloatingIPServiceImpl
extends BaseNetworkingServices
implements NetFloatingIPService {
    @Override
    public List<? extends NetFloatingIP> list() {
        return this.get(NeutronFloatingIP.FloatingIPs.class, this.uri("/floatingips", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends NetFloatingIP> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronFloatingIP.FloatingIPs> fIPsInvocation = this.get(NeutronFloatingIP.FloatingIPs.class, "/floatingips");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                fIPsInvocation = fIPsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return fIPsInvocation.execute().getList();
    }

    @Override
    public NetFloatingIP get(String fipId) {
        Objects.requireNonNull(fipId);
        return this.get(NeutronFloatingIP.class, this.uri("/floatingips/%s", fipId)).execute();
    }

    @Override
    public ActionResponse delete(String fipId) {
        Objects.requireNonNull(fipId);
        return this.deleteWithResponse(this.uri("/floatingips/%s", fipId)).execute();
    }

    @Override
    public NetFloatingIP create(NetFloatingIP floatingIp) {
        Objects.requireNonNull(floatingIp);
        Objects.requireNonNull(floatingIp.getFloatingNetworkId());
        return this.post(NeutronFloatingIP.class, this.uri("/floatingips", new Object[0])).entity(floatingIp).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public NetFloatingIP associateToPort(String fipId, String portId) {
        Objects.requireNonNull(fipId);
        Objects.requireNonNull(portId);
        String inner = String.format("{ \"port_id\":\"%s\" }", portId);
        String json = String.format("{ \"%s\": %s }", "floatingip", inner);
        return this.put(NeutronFloatingIP.class, this.uri("/floatingips/%s", fipId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public NetFloatingIP disassociateFromPort(String fipId) {
        Objects.requireNonNull(fipId);
        String json = String.format("{ \"%s\": %s }", "floatingip", "{ \"port_id\":null }");
        return this.put(NeutronFloatingIP.class, this.uri("/floatingips/%s", fipId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public PortForwardingService portForwarding() {
        return Apis.get(PortForwardingService.class);
    }
}

