/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.networking.ext.AgentService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Agent;
import org.openstack4j.openstack.networking.domain.NeutronAgent;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class AgentServiceImpl
extends BaseNetworkingServices
implements AgentService {
    @Override
    public List<? extends Agent> list() {
        return this.get(NeutronAgent.Agents.class, this.uri("/agents", new Object[0])).execute().getList();
    }

    @Override
    public Agent getAgent(String agentId) {
        Objects.requireNonNull(agentId);
        return this.get(NeutronAgent.class, this.uri("/agents/%s", agentId)).execute();
    }

    @Override
    public Agent setAdminStateUp(String agentId, boolean state) {
        Objects.requireNonNull(agentId);
        String json = String.format("{\"%s\": { \"%s\": \"%b\"}}", "agent", "admin_state_up", state);
        return this.put(NeutronAgent.class, this.uri("/agents/%s", agentId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse attachNetworkToDhcpAgent(String agentId, String networkId) {
        Objects.requireNonNull(agentId);
        String json = String.format("{\"%s\": \"%s\"}", "network_id", networkId);
        return this.postWithResponse(this.uri("/agents/%s/dhcp-networks", agentId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse detachNetworkToDhcpAgent(String agentId, String networkId) {
        Objects.requireNonNull(agentId);
        return this.deleteWithResponse(this.uri("/agents/%s/dhcp-networks/%s", agentId, networkId)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

