/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.networking.ext.MemberService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.Member;
import org.openstack4j.model.network.ext.MemberUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronMember;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class MemberServiceImpl
extends BaseNetworkingServices
implements MemberService {
    @Override
    public List<? extends Member> list() {
        return this.get(NeutronMember.Members.class, this.uri("/lb/members", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Member> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronMember.Members> req = this.get(NeutronMember.Members.class, this.uri("/lb/members", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Member get(String memberId) {
        Objects.requireNonNull(memberId);
        return this.get(NeutronMember.class, this.uri("/lb/members/%s", memberId)).execute();
    }

    @Override
    public ActionResponse delete(String memberId) {
        Objects.requireNonNull(memberId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lb/members/%s", memberId)).executeWithResponse());
    }

    @Override
    public Member create(Member member) {
        Objects.requireNonNull(member);
        return this.post(NeutronMember.class, this.uri("/lb/members", new Object[0])).entity(member).execute();
    }

    @Override
    public Member update(String memberId, MemberUpdate member) {
        Objects.requireNonNull(memberId);
        Objects.requireNonNull(member);
        return this.put(NeutronMember.class, this.uri("/lb/members/%s", memberId)).entity(member).execute();
    }
}

