/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.networking.ext.VipService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.Vip;
import org.openstack4j.model.network.ext.VipUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronVip;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class VipServiceImpl
extends BaseNetworkingServices
implements VipService {
    @Override
    public List<? extends Vip> list() {
        return this.get(NeutronVip.Vips.class, this.uri("/lb/vips", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Vip> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronVip.Vips> req = this.get(NeutronVip.Vips.class, this.uri("/lb/vips", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Vip get(String vipId) {
        Objects.requireNonNull(vipId);
        return this.get(NeutronVip.class, this.uri("/lb/vips/%s", vipId)).execute();
    }

    @Override
    public ActionResponse delete(String vipId) {
        Objects.requireNonNull(vipId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lb/vips/%s", vipId)).executeWithResponse());
    }

    @Override
    public Vip create(Vip vip) {
        Objects.requireNonNull(vip);
        return this.post(NeutronVip.class, this.uri("/lb/vips", new Object[0])).entity(vip).execute();
    }

    @Override
    public Vip update(String vipId, VipUpdate vip) {
        Objects.requireNonNull(vipId);
        Objects.requireNonNull(vip);
        return this.put(NeutronVip.class, this.uri("/lb/vips/%s", vipId)).entity(vip).execute();
    }
}

