/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.octavia.LbPoolV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.octavia.LbPoolV2;
import org.openstack4j.model.octavia.LbPoolV2Update;
import org.openstack4j.model.octavia.MemberV2;
import org.openstack4j.model.octavia.MemberV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.octavia.domain.OctaviaLbPoolV2;
import org.openstack4j.openstack.octavia.domain.OctaviaMemberV2;
import org.openstack4j.openstack.octavia.internal.BaseOctaviaServices;

public class LbPoolV2ServiceImpl
extends BaseOctaviaServices
implements LbPoolV2Service {
    @Override
    public List<? extends LbPoolV2> list() {
        return this.get(OctaviaLbPoolV2.LbPoolsV2.class, this.uri("/lbaas/pools", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LbPoolV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<OctaviaLbPoolV2.LbPoolsV2> req = this.get(OctaviaLbPoolV2.LbPoolsV2.class, this.uri("/lbaas/pools", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public LbPoolV2 get(String lbPoolId) {
        Objects.requireNonNull(lbPoolId);
        return this.get(OctaviaLbPoolV2.class, this.uri("/lbaas/pools/%s", lbPoolId)).execute();
    }

    @Override
    public LbPoolV2 create(LbPoolV2 lbPool) {
        Objects.requireNonNull(lbPool);
        return this.post(OctaviaLbPoolV2.class, this.uri("/lbaas/pools", new Object[0])).entity(lbPool).execute();
    }

    @Override
    public LbPoolV2 update(String lbPoolId, LbPoolV2Update lbPool) {
        Objects.requireNonNull(lbPoolId);
        Objects.requireNonNull(lbPool);
        return this.put(OctaviaLbPoolV2.class, this.uri("/lbaas/pools/%s", lbPoolId)).entity(lbPool).execute();
    }

    @Override
    public ActionResponse delete(String lbPoolId) {
        Objects.requireNonNull(lbPoolId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lbaas/pools/%s", lbPoolId)).executeWithResponse());
    }

    @Override
    public List<? extends MemberV2> listMembers(String lbPoolId) {
        return this.get(OctaviaMemberV2.MembersV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId)).execute().getList();
    }

    @Override
    public List<? extends MemberV2> listMembers(String lbPoolId, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<OctaviaMemberV2.MembersV2> req = this.get(OctaviaMemberV2.MembersV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public MemberV2 getMember(String lbPoolId, String memberId) {
        Objects.requireNonNull(lbPoolId);
        Objects.requireNonNull(memberId);
        return this.get(OctaviaMemberV2.class, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).execute();
    }

    @Override
    public MemberV2 createMember(String lbPoolId, MemberV2 member) {
        Objects.requireNonNull(lbPoolId);
        Objects.requireNonNull(member);
        return this.post(OctaviaMemberV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId)).entity(member).execute();
    }

    @Override
    public MemberV2 updateMember(String lbPoolId, String memberId, MemberV2Update member) {
        Objects.requireNonNull(lbPoolId);
        Objects.requireNonNull(memberId);
        Objects.requireNonNull(member);
        return this.put(OctaviaMemberV2.class, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).entity(member).execute();
    }

    @Override
    public ActionResponse deleteMember(String lbPoolId, String memberId) {
        Objects.requireNonNull(lbPoolId);
        Objects.requireNonNull(memberId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).executeWithResponse());
    }
}

