/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.placement.internal.ext;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.placement.ext.ResourceProviderService;
import org.openstack4j.model.placement.ext.ResourceProvider;
import org.openstack4j.model.placement.ext.ResourceProviderInventories;
import org.openstack4j.model.placement.ext.ResourceProviderUsages;
import org.openstack4j.openstack.placement.domain.ResourceProviderInventoriesBody;
import org.openstack4j.openstack.placement.domain.ResourceProviderUsagesBody;
import org.openstack4j.openstack.placement.domain.ext.ExtResourceProvider;
import org.openstack4j.openstack.placement.internal.BasePlacementServices;

public class ResourceProviderServiceImpl
extends BasePlacementServices
implements ResourceProviderService {
    @Override
    public ResourceProvider get(String resourceProviderId) {
        Objects.requireNonNull(resourceProviderId);
        return this.get(ExtResourceProvider.class, this.uri("/resource_providers/%s", resourceProviderId)).execute();
    }

    @Override
    public List<? extends ResourceProvider> list() {
        return this.get(ExtResourceProvider.ResourceProviders.class, "/resource_providers").execute().getList();
    }

    @Override
    public ResourceProviderInventories resourceProviderInventories(String resourceProviderId) {
        Objects.requireNonNull(resourceProviderId);
        return this.get(ResourceProviderInventoriesBody.class, this.uri("/resource_providers/%s/inventories", resourceProviderId)).execute().getInventories();
    }

    @Override
    public ResourceProviderUsages resourceProviderUsages(String resourceProviderId) {
        Objects.requireNonNull(resourceProviderId);
        return this.get(ResourceProviderUsagesBody.class, this.uri("/resource_providers/%s/usages", resourceProviderId)).execute().getUsages();
    }
}

