/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.sahara.Job;
import org.openstack4j.model.sahara.JobBinary;
import org.openstack4j.model.sahara.builder.JobBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaJobBinary;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="job")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SaharaJob
implements Job {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="mains")
    private List<SaharaJobBinary> mains;
    @JsonProperty(value="libs")
    private List<SaharaJobBinary> libs;
    private List<String> mainBinaryIds;
    private List<String> libBinaryIds;

    public static JobBuilder builder() {
        return new ConcreteJobBuilder();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<? extends JobBinary> getFullMains() {
        return this.mains;
    }

    @Override
    public List<? extends JobBinary> getFullLibs() {
        return this.libs;
    }

    @Override
    public List<String> getMains() {
        return this.mainBinaryIds;
    }

    @Override
    public List<String> getLibs() {
        return this.libBinaryIds;
    }

    public String toString() {
        return new ToStringHelper(this).add("description", this.description).add("url", this.url).add("tenant_id", this.tenantId).add("created_at", this.createdAt).add("updated_at", this.updatedAt).add("id", this.id).add("name", this.name).add("mains", this.mains).add("libs", this.libs).add("type", this.type).toString();
    }

    @Override
    public JobBuilder toBuilder() {
        return new ConcreteJobBuilder(this);
    }

    public static class ConcreteJobBuilder
    implements JobBuilder {
        SaharaJob m;

        ConcreteJobBuilder() {
            this(new SaharaJob());
        }

        ConcreteJobBuilder(SaharaJob m) {
            this.m = m;
        }

        @Override
        public Job build() {
            return this.m;
        }

        @Override
        public JobBuilder from(Job in) {
            this.m = (SaharaJob)in;
            return this;
        }

        @Override
        public JobBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public JobBuilder type(String type) {
            this.m.type = type;
            return this;
        }

        @Override
        public JobBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        @JsonProperty(value="mains")
        public JobBuilder setMain(String jobBinaryId) {
            if (this.m.mainBinaryIds == null) {
                this.m.mainBinaryIds = new ArrayList();
            }
            this.m.mainBinaryIds.add(jobBinaryId);
            return this;
        }

        @Override
        @JsonProperty(value="libs")
        public JobBuilder addLibs(String jobBinaryId) {
            if (this.m.libBinaryIds == null) {
                this.m.libBinaryIds = new ArrayList();
            }
            this.m.libBinaryIds.add(jobBinaryId);
            return this;
        }
    }

    public static class Jobs
    extends ListResult<SaharaJob> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="jobs")
        private List<SaharaJob> jobs;

        @Override
        protected List<SaharaJob> value() {
            return this.jobs;
        }
    }
}

