/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.Apis;
import org.openstack4j.api.Builders;
import org.openstack4j.api.storage.BlockVolumeService;
import org.openstack4j.api.storage.BlockVolumeTransferService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeType;
import org.openstack4j.model.storage.block.VolumeTypeEncryption;
import org.openstack4j.model.storage.block.VolumeUploadImage;
import org.openstack4j.model.storage.block.options.UploadImageData;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.storage.block.domain.AttachAction;
import org.openstack4j.openstack.storage.block.domain.CinderUploadImageData;
import org.openstack4j.openstack.storage.block.domain.CinderVolume;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeMigration;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeType;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeTypeEncryption;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeTypeEncryptionFetch;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeUploadImage;
import org.openstack4j.openstack.storage.block.domain.DetachAction;
import org.openstack4j.openstack.storage.block.domain.ExtendAction;
import org.openstack4j.openstack.storage.block.domain.ForceDeleteAction;
import org.openstack4j.openstack.storage.block.domain.ForceDetachAction;
import org.openstack4j.openstack.storage.block.domain.ForceDetachConnector;
import org.openstack4j.openstack.storage.block.domain.ResetStatusAction;
import org.openstack4j.openstack.storage.block.domain.SetBootableAction;
import org.openstack4j.openstack.storage.block.domain.UpdateReadOnlyFlagAction;
import org.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockVolumeServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeService {
    @Override
    public List<? extends VolumeType> listVolumeTypes() {
        return this.get(CinderVolumeType.VolumeTypes.class, this.uri("/types", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Volume> list() {
        return this.get(CinderVolume.Volumes.class, this.uri("/volumes/detail", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Volume> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolume.Volumes> volumeInvocation = this.buildInvocation(filteringParams);
        return volumeInvocation.execute().getList();
    }

    @Override
    public List<? extends Volume> listAll() {
        return this.get(CinderVolume.Volumes.class, this.uri("/volumes/detail", new Object[0])).param("all_tenants", 1).execute().getList();
    }

    @Override
    public Volume get(String volumeId) {
        Objects.requireNonNull(volumeId);
        return this.get(CinderVolume.class, this.uri("/volumes/%s", volumeId)).execute();
    }

    @Override
    public ActionResponse delete(String volumeId) {
        Objects.requireNonNull(volumeId);
        return this.deleteWithResponse(this.uri("/volumes/%s", volumeId)).execute();
    }

    @Override
    public ActionResponse forceDelete(String volumeId) {
        Objects.requireNonNull(volumeId);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ForceDeleteAction()).execute();
    }

    @Override
    public ActionResponse resetState(String volumeId, Volume.Status status) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(status);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ResetStatusAction(status)).execute();
    }

    @Override
    public ActionResponse extend(String volumeId, Integer newSize) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(newSize);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ExtendAction(newSize)).execute();
    }

    @Override
    public ActionResponse bootable(String volumeId, Boolean bootable) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(bootable);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new SetBootableAction(bootable)).execute();
    }

    @Override
    public Volume create(Volume volume) {
        Objects.requireNonNull(volume);
        return this.post(CinderVolume.class, this.uri("/volumes", new Object[0])).entity(volume).execute();
    }

    @Override
    public ActionResponse update(String volumeId, String name, String description) {
        Objects.requireNonNull(volumeId);
        if (name == null && description == null) {
            return ActionResponse.actionFailed("Name and Description are both required", 412);
        }
        return this.put(ActionResponse.class, this.uri("/volumes/%s", volumeId)).entity((ModelEntity)Builders.volume().name(name).description(description).build()).execute();
    }

    @Override
    public void deleteVolumeType(String volumeTypeId) {
        Objects.requireNonNull(volumeTypeId);
        this.delete(Void.class, this.uri("/types/%s", volumeTypeId)).execute();
    }

    @Override
    public VolumeType createVolumeType(VolumeType volumeType) {
        Objects.requireNonNull(volumeType);
        return this.post(CinderVolumeType.class, this.uri("/types", new Object[0])).entity(volumeType).execute();
    }

    @Override
    public VolumeTypeEncryption createVolumeTypeEncryption(String volumeTypeId, VolumeTypeEncryption volumeTypeEncryption) {
        Objects.requireNonNull(volumeTypeEncryption);
        Objects.requireNonNull(volumeTypeId);
        return this.post(CinderVolumeTypeEncryption.class, this.uri("/types/%s/encryption", volumeTypeId)).entity(volumeTypeEncryption).execute();
    }

    @Override
    public VolumeTypeEncryption getVolumeTypeEncryption(String volumeTypeId) {
        Objects.requireNonNull(volumeTypeId);
        return this.get(CinderVolumeTypeEncryptionFetch.class, this.uri("/types/%s/encryption", volumeTypeId)).execute();
    }

    @Override
    public void deleteVolumeTypeEncryption(String volumeTypeId, String encryptionId) {
        Objects.requireNonNull(encryptionId);
        Objects.requireNonNull(volumeTypeId);
        this.delete(Void.class, this.uri("/types/%s/encryption/%s", volumeTypeId, encryptionId)).execute();
    }

    @Override
    public ActionResponse migrate(String volumeId, String hostService, boolean forceHostCopy) {
        CinderVolumeMigration migration = new CinderVolumeMigration(hostService, forceHostCopy);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(migration).execute();
    }

    @Override
    public VolumeUploadImage uploadToImage(String volumeId, UploadImageData data) {
        Objects.requireNonNull(volumeId, "volumeId");
        Objects.requireNonNull(data, "UploadImageData");
        return this.post(CinderVolumeUploadImage.class, this.uri("/volumes/%s/action", volumeId)).entity(CinderUploadImageData.create(data)).execute();
    }

    @Override
    public BlockVolumeTransferService transfer() {
        return Apis.get(BlockVolumeTransferService.class);
    }

    private BaseOpenStackService.Invocation<CinderVolume.Volumes> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolume.Volumes> volumeInvocation = this.get(CinderVolume.Volumes.class, "/volumes/detail");
        if (filteringParams == null) {
            return volumeInvocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
        }
        return volumeInvocation;
    }

    @Override
    public ActionResponse readOnlyModeUpdate(String volumeId, boolean readonly) {
        Objects.requireNonNull(volumeId);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new UpdateReadOnlyFlagAction(readonly)).execute();
    }

    @Override
    public ActionResponse attach(String volumeId, String instanceId, String mountpoint, String hostName) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(instanceId);
        Objects.requireNonNull(mountpoint);
        Objects.requireNonNull(hostName);
        AttachAction attach = new AttachAction(instanceId, mountpoint, hostName);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(attach).execute();
    }

    @Override
    public ActionResponse forceDetach(String volumeId, String initiator, String attachmentId) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(initiator);
        Objects.requireNonNull(attachmentId);
        ForceDetachConnector connector = new ForceDetachConnector(initiator);
        ForceDetachAction detach = new ForceDetachAction(attachmentId, connector);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(detach).execute();
    }

    @Override
    public ActionResponse detach(String volumeId, String attachmentId) {
        Objects.requireNonNull(volumeId);
        Objects.requireNonNull(attachmentId);
        DetachAction detach = new DetachAction(attachmentId);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(detach).execute();
    }
}

