/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.domain;

import java.util.Map;
import org.openstack4j.model.storage.object.SwiftAccount;
import org.openstack4j.util.ToStringHelper;

public class SwiftAccountImpl
implements SwiftAccount {
    private static final long serialVersionUID = -5316007949264717108L;
    private long containerCount;
    private long objectCount;
    private long bytesUsed;
    private String temporaryUrlKey;
    private Map<String, String> metadata;

    protected SwiftAccountImpl() {
    }

    public static AccountBuilder builder() {
        return new AccountBuilder();
    }

    @Override
    public long getContainerCount() {
        return this.containerCount;
    }

    @Override
    public long getObjectCount() {
        return this.objectCount;
    }

    @Override
    public long getBytesUsed() {
        return this.bytesUsed;
    }

    @Override
    public String getTemporaryUrlKey() {
        return this.temporaryUrlKey;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return new ToStringHelper(this).add("containerCount", this.containerCount).add("objectCount", this.objectCount).add("bytesUsed", this.bytesUsed).add("temporaryUrlKey", this.temporaryUrlKey).add("metadata", this.metadata).toString();
    }

    public static class AccountBuilder {
        private SwiftAccountImpl account = new SwiftAccountImpl();

        public AccountBuilder containerCount(long containerCount) {
            this.account.containerCount = containerCount;
            return this;
        }

        public AccountBuilder objectCount(long objectCount) {
            this.account.objectCount = objectCount;
            return this;
        }

        public AccountBuilder bytesUsed(long bytesUsed) {
            this.account.bytesUsed = bytesUsed;
            return this;
        }

        public AccountBuilder temporaryUrlKey(String temporaryUrlKey) {
            this.account.temporaryUrlKey = temporaryUrlKey;
            return this;
        }

        public AccountBuilder metadata(Map<String, String> metadata) {
            this.account.metadata = metadata;
            return this;
        }

        public SwiftAccountImpl build() {
            return this.account;
        }
    }
}

