/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MetadataToHeadersFunction
implements Function<Map<String, String>, Map<String, String>> {
    private String prefix;

    private MetadataToHeadersFunction(String prefix) {
        this.prefix = prefix;
    }

    public static <R> MetadataToHeadersFunction create(String prefix) {
        return new MetadataToHeadersFunction(prefix);
    }

    @Override
    public Map<String, String> apply(Map<String, String> metadata) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : metadata.keySet()) {
            String keyLower = key.toLowerCase();
            String value = metadata.get(key);
            if (keyLower.startsWith(this.prefix.toLowerCase())) {
                headers.put(keyLower, value);
                continue;
            }
            headers.put(String.format("%s%s", this.prefix, keyLower), value);
        }
        return headers;
    }
}

