/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstack4j.api.storage.ObjectStorageObjectService;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.DLPayload;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.payloads.FilePayload;
import org.openstack4j.model.storage.block.options.DownloadOptions;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectDeleteOptions;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectLocation;
import org.openstack4j.model.storage.object.options.ObjectPutOptions;
import org.openstack4j.openstack.common.DLPayloadEntity;
import org.openstack4j.openstack.common.functions.HeaderNameValuesToHeaderMap;
import org.openstack4j.openstack.storage.object.domain.SwiftObjectImpl;
import org.openstack4j.openstack.storage.object.functions.ApplyContainerToObjectFunction;
import org.openstack4j.openstack.storage.object.functions.MapWithoutMetaPrefixFunction;
import org.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;
import org.openstack4j.openstack.storage.object.functions.ParseObjectFunction;
import org.openstack4j.openstack.storage.object.internal.BaseObjectStorageService;

public class ObjectStorageObjectServiceImpl
extends BaseObjectStorageService
implements ObjectStorageObjectService {
    @Override
    public List<? extends SwiftObject> list(String containerName) {
        Objects.requireNonNull(containerName);
        List objs = this.get(SwiftObjectImpl.SwiftObjects.class, this.uri("/%s", containerName)).param("format", "json").execute();
        if (objs == null) {
            return Collections.emptyList();
        }
        return objs.stream().map(ApplyContainerToObjectFunction.create(containerName)).collect(Collectors.toList());
    }

    @Override
    public List<? extends SwiftObject> list(String containerName, ObjectListOptions options) {
        if (options == null) {
            return this.list(containerName);
        }
        Objects.requireNonNull(containerName);
        List objs = this.get(SwiftObjectImpl.SwiftObjects.class, this.uri("/%s", containerName)).param("format", "json").params(options.getOptions()).execute();
        if (objs == null) {
            return Collections.emptyList();
        }
        return objs.stream().map(ApplyContainerToObjectFunction.create(containerName)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SwiftObject get(ObjectLocation location) {
        Objects.requireNonNull(location);
        HttpResponse resp = this.head(Void.class, location.getURI()).executeWithResponse();
        try {
            if (resp.getStatus() == 404) {
                SwiftObject swiftObject = null;
                return swiftObject;
            }
            SwiftObject swiftObject = ParseObjectFunction.create(location).apply(resp);
            return swiftObject;
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
    }

    @Override
    public SwiftObject get(String containerName, String name) {
        return this.get(ObjectLocation.create(containerName, name));
    }

    @Override
    public String put(String containerName, String name, Payload<?> payload) {
        return this.put(containerName, name, payload, ObjectPutOptions.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String containerName, String name, Payload<?> payload, ObjectPutOptions options) {
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(options);
        if (payload != null && FilePayload.class.isAssignableFrom(payload.getClass()) && name == null) {
            name = ((FilePayload)FilePayload.class.cast(payload)).getRaw().getName();
        } else {
            Objects.requireNonNull(name);
        }
        if (options.getPath() != null && name.indexOf(47) == -1) {
            name = options.getPath() + "/" + name;
        }
        HttpResponse resp = this.put(Void.class, this.uri("/%s/%s", containerName, name)).entity(payload).headers(options.getOptions()).contentType(options.getContentType()).paramLists(options.getQueryParams()).executeWithResponse();
        try {
            String string = resp.header("Etag");
            return string;
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
    }

    @Override
    public ActionResponse delete(String containerName, String name) {
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(name);
        return this.delete(ObjectLocation.create(containerName, name));
    }

    @Override
    public ActionResponse delete(ObjectLocation location) {
        return this.delete(location, ObjectDeleteOptions.NONE);
    }

    @Override
    public ActionResponse delete(ObjectLocation location, ObjectDeleteOptions options) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(options);
        return this.delete(ActionResponse.class, location.getURI()).paramLists(options.getQueryParams()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copy(ObjectLocation source, ObjectLocation dest) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(dest);
        HttpResponse resp = this.put(Void.class, dest.getURI()).header("X-Copy-From", source.getURI()).header("Content-Length", 0).executeWithResponse();
        try {
            String string = resp.header("Etag");
            return string;
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMetadata(ObjectLocation location) {
        Objects.requireNonNull(location);
        HttpResponse resp = this.head(Void.class, location.getURI()).executeWithResponse();
        try {
            Map<String, String> map = MapWithoutMetaPrefixFunction.INSTANCE.apply(resp.headers());
            return map;
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
    }

    @Override
    public Map<String, String> getMetadata(String containerName, String name) {
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(name);
        return this.getMetadata(ObjectLocation.create(containerName, name));
    }

    @Override
    public boolean updateMetadata(ObjectLocation location, Map<String, String> metadata) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(metadata);
        return this.isResponseSuccess(this.post(Void.class, location.getURI()).headers(MetadataToHeadersFunction.create("X-Object-Meta-").apply(metadata)).executeWithResponse(), 202);
    }

    @Override
    public DLPayload download(String containerName, String name) {
        return this.download(ObjectLocation.create(containerName, name), DownloadOptions.create());
    }

    @Override
    public DLPayload download(String containerName, String name, DownloadOptions options) {
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(name);
        Objects.requireNonNull(options);
        return this.download(ObjectLocation.create(containerName, name), options);
    }

    @Override
    public DLPayload download(ObjectLocation location, DownloadOptions options) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(options);
        return DLPayloadEntity.create(this.get(Void.class, location.getURI()).headers(HeaderNameValuesToHeaderMap.INSTANCE.apply(options.getHeaders())).executeWithResponse());
    }
}

