/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.tacker.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.tacker.VnfService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.tacker.Vnf;
import org.openstack4j.model.tacker.VnfUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.tacker.domain.TackerVnf;
import org.openstack4j.openstack.tacker.internal.BaseTackerServices;

public class VnfServiceImpl
extends BaseTackerServices
implements VnfService {
    public List<? extends TackerVnf> list() {
        return this.get(TackerVnf.TackerVnfs.class, this.uri("/vnfs", new Object[0])).execute().getList();
    }

    public List<? extends TackerVnf> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<TackerVnf.TackerVnfs> req = this.get(TackerVnf.TackerVnfs.class, this.uri("/vnfs", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public TackerVnf get(String vnfId) {
        Objects.requireNonNull(vnfId);
        return this.get(TackerVnf.class, this.uri("/vnfs/%s", vnfId)).execute();
    }

    @Override
    public ActionResponse delete(String vnfId) {
        Objects.requireNonNull(vnfId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vnfs/%s", vnfId)).executeWithResponse());
    }

    @Override
    public Vnf create(Vnf vnf) {
        return this.post(TackerVnf.class, this.uri("/vnfs", new Object[0])).entity(vnf).execute(ExecutionOptions.create(PropagateOnStatus.on(500)));
    }

    @Override
    public Vnf update(String vnfId, VnfUpdate vnfUpdate) {
        Objects.requireNonNull(vnfId);
        Objects.requireNonNull(vnfUpdate);
        return this.put(TackerVnf.class, this.uri("/vnfs/%s", vnfId)).entity(vnfUpdate).execute();
    }
}

