/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.telemetry.AlarmAodhService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.telemetry.Alarm;
import org.openstack4j.openstack.telemetry.domain.CeilometerAlarm;
import org.openstack4j.openstack.telemetry.internal.BaseTelemetryAodhServices;

public class AlarmAodhServiceImpl
extends BaseTelemetryAodhServices
implements AlarmAodhService {
    @Override
    public List<? extends Alarm> list() {
        CeilometerAlarm[] alarms = this.get(CeilometerAlarm[].class, this.uri("/alarms", new Object[0])).execute();
        return this.wrapList(alarms);
    }

    @Override
    public Alarm getById(String alarmId) {
        Objects.requireNonNull(alarmId);
        return this.get(CeilometerAlarm.class, this.uri("/alarms/%s", alarmId)).execute();
    }

    @Override
    public void update(String alarmId, Alarm alarm) {
        Objects.requireNonNull(alarmId);
        Objects.requireNonNull(alarm);
        this.put(CeilometerAlarm.class, this.uri("/alarms/%s", alarmId)).entity(alarm).execute();
    }

    @Override
    public Alarm create(Alarm alarm) {
        Objects.requireNonNull(alarm);
        return this.post(CeilometerAlarm.class, this.uri("/alarms", new Object[0])).entity(alarm).execute();
    }

    @Override
    public ActionResponse delete(String alarmId) {
        Objects.requireNonNull(alarmId);
        return this.deleteWithResponse(this.uri("/alarms/%s", alarmId)).execute();
    }
}

