/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.util;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ToStringHelper {
    private static final boolean omitNullValues = true;
    private final String className;
    private final ValueHolder holderHead;
    private ValueHolder holderTail;

    public ToStringHelper(Object subject) {
        this(subject.getClass().getName());
    }

    public ToStringHelper(String className) {
        this.holderTail = this.holderHead = new ValueHolder();
        this.className = Objects.requireNonNull(className, "Call name cannot be null");
    }

    public ToStringHelper add(String name, @Nullable Object value) {
        return this.addHolder(name, value);
    }

    public ToStringHelper add(String name, boolean value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper add(String name, char value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper add(String name, double value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper add(String name, float value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper add(String name, int value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper add(String name, long value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringHelper addValue(@Nullable Object value) {
        return this.addHolder(value);
    }

    public String toString() {
        String nextSeparator = "";
        StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
        ValueHolder valueHolder = this.holderHead.next;
        while (valueHolder != null) {
            Object value = valueHolder.value;
            if (value != null) {
                builder.append(nextSeparator);
                nextSeparator = ", ";
                if (valueHolder.name != null) {
                    builder.append(valueHolder.name).append('=');
                }
                if (value != null && value.getClass().isArray()) {
                    Object[] objectArray = new Object[]{value};
                    String arrayString = Arrays.deepToString(objectArray);
                    builder.append(arrayString, 1, arrayString.length() - 1);
                } else {
                    builder.append(value);
                }
            }
            valueHolder = valueHolder.next;
        }
        return builder.append('}').toString();
    }

    private ValueHolder addHolder() {
        ValueHolder valueHolder;
        this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
        return valueHolder;
    }

    private ToStringHelper addHolder(@Nullable Object value) {
        ValueHolder valueHolder = this.addHolder();
        valueHolder.value = value;
        return this;
    }

    private ToStringHelper addHolder(String name, @Nullable Object value) {
        ValueHolder valueHolder = this.addHolder();
        valueHolder.value = value;
        valueHolder.name = Objects.requireNonNull(name, "Field name cannot be null");
        return this;
    }

    private static final class ValueHolder {
        @Nullable
        String name;
        @Nullable
        Object value;
        @Nullable
        ValueHolder next;

        private ValueHolder() {
        }
    }
}

