/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.github.phillipkruger.apiee.SwaggerCache;
import com.github.phillipkruger.apiee.Templates;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/apiee/")
public class ApieeService {
    private static final Logger log = Logger.getLogger(ApieeService.class.getName());
    @Context
    private Application application;
    @Inject
    private SwaggerCache swaggerCache;
    @Inject
    private Templates templates;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP = "http";
    private static final String INDEX_HTML = "index.html";
    private static final String X_REQUEST_URI = "x-request-uri";
    private static final String X_FORWARDED_PORT = "x-forwarded-port";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String LOCALHOST = "localhost";

    @GET
    @Produces(value={"image/png"})
    @Path(value="favicon-{size}.png")
    public byte[] getFavicon(@Context HttpServletRequest request, @PathParam(value="size") int size) {
        return this.templates.getFavicon(size);
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="logo.png")
    public byte[] getLogo(@Context HttpServletRequest request) {
        return this.templates.getOriginalLogo();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="index.html")
    public Response getSwaggerUI(@Context HttpServletRequest request) {
        String swaggerUI = this.templates.getSwaggerUIHtml(request);
        return Response.ok((Object)swaggerUI, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/css"})
    @Path(value="apiee.css")
    public Response getCss(@Context HttpServletRequest request) {
        String css = this.templates.getStyle();
        return Response.ok((Object)css, (String)"text/css").build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response getSwaggerUINaked(@Context UriInfo info) {
        URI fw = info.getRequestUriBuilder().path(INDEX_HTML).build(new Object[0]);
        return Response.temporaryRedirect((URI)fw).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="swagger.json")
    public String getSwaggerJson(@Context HttpServletRequest request) {
        URL url = this.getOriginalRequestURL(request);
        if (url != null) {
            Set classes = this.application.getClasses();
            String json = this.swaggerCache.getSwaggerJson(classes, url);
            return json;
        }
        return null;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="swagger.yaml")
    public String getSwaggerYaml(@Context HttpServletRequest request) {
        URL url = this.getOriginalRequestURL(request);
        if (url != null) {
            Set classes = this.application.getClasses();
            return this.swaggerCache.getSwaggerYaml(classes, url);
        }
        return null;
    }

    private URL getOriginalRequestURL(HttpServletRequest request) {
        try {
            String path = this.getOriginalPath(request);
            String scheme = this.getOriginalRequestScheme(request);
            String host = this.getOriginalRequestHost(request);
            int port = this.getOriginalRequestPort(request, scheme);
            URL u = new URL(scheme, host, port, path);
            return u;
        }
        catch (MalformedURLException ex) {
            log.warning("Could not determine URL for swagger.json");
            return null;
        }
    }

    private int getOriginalRequestPort(HttpServletRequest request, String scheme) {
        int original = request.getServerPort();
        if (original != -1 && original > 0 && original != 80 && original != 443) {
            return original;
        }
        int portFromHeader = request.getIntHeader(X_FORWARDED_PORT);
        if (portFromHeader != -1 && portFromHeader > 0 && portFromHeader != 80 && portFromHeader != 443) {
            return portFromHeader;
        }
        try {
            int portFromUrl = new URL(request.getRequestURL().toString()).getPort();
            if (portFromUrl != -1 && portFromUrl > 0 && portFromUrl != 80 && portFromUrl != 443) {
                return portFromUrl;
            }
            return this.getDefaultPort(scheme);
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL port - {0}", ex.getMessage());
            return this.getDefaultPort(scheme);
        }
    }

    private int getDefaultPort(String scheme) {
        if (scheme == null || scheme.isEmpty() || scheme.equalsIgnoreCase(HTTP)) {
            return 80;
        }
        return 443;
    }

    private String getOriginalRequestHost(HttpServletRequest request) {
        String original = request.getServerName();
        if (original != null && !original.isEmpty()) {
            return original;
        }
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL host - {0}", ex.getMessage());
            return LOCALHOST;
        }
    }

    private String getOriginalRequestScheme(HttpServletRequest request) {
        String original = request.getHeader(X_FORWARDED_PROTO);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        try {
            return new URL(request.getRequestURL().toString()).getProtocol();
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL scheme - {0}", ex.getMessage());
            return HTTP;
        }
    }

    private String getOriginalPath(HttpServletRequest request) {
        String original = request.getHeader(X_REQUEST_URI);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        return request.getRequestURI();
    }
}

