/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.phillipkruger.apiee.WhiteLabel;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;

@ApplicationScoped
public class SwaggerCache {
    private static final Logger log = Logger.getLogger(SwaggerCache.class.getName());
    private final Map<Integer, String> swaggerMap = new ConcurrentHashMap<Integer, String>();
    @Inject
    private WhiteLabel whiteLabel;
    private static final String APIEE_CONTEXT = "/apiee/";
    private static final String DOUBLE_POINT = ":";
    private static final String SLASH = "/";
    private static final String INFO_TITLE = "infoTitle";
    private static final String INFO_DESC = "infoDescription";
    private static final String INFO_VERSION = "infoVersion";
    private static final String INFO_TERMS = "infoTermsOfService";
    private static final String INFO_CONTACT_NAME = "infoContactName";
    private static final String INFO_CONTACT_EMAIL = "infoContactEmail";
    private static final String INFO_CONTACT_URL = "infoContactUrl";
    private static final String INFO_LICENSE_NAME = "infoLicenseName";
    private static final String INFO_LICENSE_URL = "infoLicenseUrl";

    public String getSwaggerJson(Set<Class<?>> classes, @NotNull URL url) {
        int hash = url.toExternalForm().hashCode();
        if (this.swaggerMap.containsKey(hash)) {
            log.log(Level.FINEST, "Loading {0} from cache", url);
            return this.swaggerMap.get(hash);
        }
        return this.generateJson(hash, classes, url);
    }

    public String getSwaggerYaml(Set<Class<?>> classes, @NotNull URL url) {
        int hash = url.toExternalForm().hashCode();
        if (this.swaggerMap.containsKey(hash)) {
            log.log(Level.FINEST, "Loading {0} from cache", url);
            return this.swaggerMap.get(hash);
        }
        return this.generateYaml(hash, classes, url);
    }

    private String generateJson(int hash, Set<Class<?>> classes, URL url) {
        log.log(Level.FINEST, "Generating {0} response from context", url);
        Swagger swagger = this.createSwagger(classes, url);
        try {
            String swaggerJson = Json.pretty().writeValueAsString((Object)swagger);
            this.swaggerMap.put(hash, swaggerJson);
            return swaggerJson;
        }
        catch (JsonProcessingException ex) {
            log.log(Level.WARNING, "Could not generate {0} - {1}", new Object[]{url.toString(), ex.getMessage()});
            log.log(Level.WARNING, "Could not generate {0} - null", new Object[]{url.toString()});
            return null;
        }
    }

    private String generateYaml(int hash, Set<Class<?>> classes, URL url) {
        log.log(Level.FINEST, "Generating {0} response for context", url);
        Swagger swagger = this.createSwagger(classes, url);
        try {
            String swaggerYaml = Yaml.pretty().writeValueAsString((Object)swagger);
            this.swaggerMap.put(hash, swaggerYaml);
            return swaggerYaml;
        }
        catch (JsonProcessingException ex) {
            log.log(Level.WARNING, "Could not generate {0} - {1}", new Object[]{url.toString(), ex.getMessage()});
            log.log(Level.WARNING, "Could not generate {0} - null", new Object[]{url.toString()});
            return null;
        }
    }

    private Swagger createSwagger(Set<Class<?>> classes, URL url) {
        Swagger swagger = new Reader(new Swagger()).read(classes);
        swagger.addScheme(Scheme.forValue((String)url.getProtocol().toUpperCase()));
        swagger.setHost(url.getHost() + DOUBLE_POINT + url.getPort());
        swagger.setBasePath(this.getBasePath(swagger.getBasePath(), url));
        Info info = this.getSwaggerInfo();
        if (info != null) {
            swagger.setInfo(info);
        }
        return swagger;
    }

    private String getBasePath(String existingBasePath, URL url) {
        String path = url.getPath();
        if (existingBasePath != null && !existingBasePath.isEmpty()) {
            int i = path.indexOf(existingBasePath + SLASH);
            return path.substring(0, i) + existingBasePath;
        }
        int i = path.indexOf(APIEE_CONTEXT);
        return path.substring(0, i);
    }

    private Info getSwaggerInfo() {
        String terms;
        String version;
        String description;
        Contact contact = this.getSwaggerContact();
        License license = this.getSwaggerLicense();
        String title = this.whiteLabel.getProperty(INFO_TITLE, null);
        if (this.isSet(title, description = this.whiteLabel.getProperty(INFO_DESC, null), version = this.whiteLabel.getProperty(INFO_VERSION, null), terms = this.whiteLabel.getProperty(INFO_TERMS, null)) || contact != null || license != null) {
            Info info = new Info();
            if (this.isSet(title)) {
                info.setTitle(title);
            }
            if (this.isSet(description)) {
                info.setDescription(description);
            }
            if (this.isSet(version)) {
                info.setVersion(version);
            }
            if (this.isSet(terms)) {
                info.setTermsOfService(terms);
            }
            if (contact != null) {
                info.setContact(contact);
            }
            if (license != null) {
                info.setLicense(license);
            }
            return info;
        }
        return null;
    }

    private Contact getSwaggerContact() {
        String name = this.whiteLabel.getProperty(INFO_CONTACT_NAME, null);
        String email = this.whiteLabel.getProperty(INFO_CONTACT_EMAIL, null);
        String url = this.whiteLabel.getProperty(INFO_CONTACT_URL, null);
        if (this.isSet(name, email, url)) {
            Contact contact = new Contact();
            if (this.isSet(email)) {
                contact.setEmail(email);
            }
            if (this.isSet(name)) {
                contact.setName(name);
            }
            if (this.isSet(url)) {
                contact.setUrl(url);
            }
            return contact;
        }
        return null;
    }

    private License getSwaggerLicense() {
        String name = this.whiteLabel.getProperty(INFO_LICENSE_NAME, null);
        String url = this.whiteLabel.getProperty(INFO_LICENSE_URL, null);
        if (this.isSet(name, url)) {
            License license = new License();
            if (this.isSet(name)) {
                license.setName(name);
            }
            if (this.isSet(url)) {
                license.setUrl(url);
            }
            return license;
        }
        return null;
    }

    private boolean isSet(String ... value) {
        for (String v : value) {
            if (v == null || v.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

