/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.github.phillipkruger.apiee.WhiteLabel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

@ApplicationScoped
public class Templates {
    private static final Logger log = Logger.getLogger(Templates.class.getName());
    private byte[] originalLogo = null;
    private byte[] favicon32 = null;
    private byte[] favicon16 = null;
    private String style = null;
    @Inject
    private WhiteLabel whiteLabel;
    private String swaggerUIHtml = null;
    private static final String VAR_CONTEXT_ROOT = "%contextRoot%";
    private static final String VAR_CURRENT_YEAR = "%currentYear%";
    private static final String VAR_COPYRIGHT_BY = "%copyrighBy%";
    private static final String VAL_COPYRIGHT_BY = "Phillip Kruger";
    private static final String VAR_TITLE = "%title%";
    private static final String VAL_TITLE = "Apiee - Swagger for Java EE";
    private static final String VAR_JSON_BUTTON = "%jsonButtonCaption%";
    private static final String VAL_JSON_BUTTON = "json";
    private static final String VAR_YAML_BUTTON = "%yamlButtonCaption%";
    private static final String VAL_YAML_BUTTON = "yaml";
    private static final String VAR_SWAGGER_THEME = "%swaggerUiTheme%";
    private static final String VAL_SWAGGER_THEME = "muted";
    private static final String PERSENTAGE = "%";
    private static final String PNG = "png";
    private static final String NL = "\n";
    private static final String EMPTY = "";
    private static final String FILE_TEMPLATE = "META-INF/resources/apiee/template.html";
    private static final String FILE_LOGO = "META-INF/resources/apiee/logo.png";
    private static final String FILE_STYLE = "META-INF/resources/apiee/style.css";

    @PostConstruct
    public void afterCreate() {
        BufferedImage image = this.getLogo();
        BufferedImage image16 = this.getFavicon(16, image);
        BufferedImage image32 = this.getFavicon(32, image);
        try {
            this.originalLogo = this.toBytes(image);
            log.finest("Apiee UI: Created logo");
            this.favicon16 = this.toBytes(image16);
            this.favicon32 = this.toBytes(image32);
            log.finest("Apiee UI: Created favicons");
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        this.style = this.getCss();
    }

    public String getSwaggerUIHtml(HttpServletRequest request) {
        if (this.swaggerUIHtml == null) {
            this.swaggerUIHtml = this.parseHtmlTemplate(request);
        }
        return this.swaggerUIHtml;
    }

    public byte[] getFavicon(int size) {
        if (size > 24) {
            return this.getFavicon32();
        }
        return this.getFavicon16();
    }

    private String parseHtmlTemplate(HttpServletRequest request) {
        String html = this.getHTMLTemplate();
        html = html.replaceAll(VAR_CONTEXT_ROOT, request.getContextPath());
        html = html.replaceAll(VAR_CURRENT_YEAR, String.valueOf(Calendar.getInstance().get(1)));
        if (this.whiteLabel.hasProperties()) {
            Map<String, String> properties = this.whiteLabel.getProperties();
            Set<Map.Entry<String, String>> pes = properties.entrySet();
            for (Map.Entry<String, String> p : pes) {
                String key = PERSENTAGE + p.getKey() + PERSENTAGE;
                html = html.replaceAll(key, p.getValue());
            }
        } else {
            log.warning("No white label properties, returning vanilla template");
        }
        html = html.replaceAll(VAR_COPYRIGHT_BY, VAL_COPYRIGHT_BY);
        html = html.replaceAll(VAR_TITLE, VAL_TITLE);
        html = html.replaceAll(VAR_JSON_BUTTON, VAL_JSON_BUTTON);
        html = html.replaceAll(VAR_YAML_BUTTON, VAL_YAML_BUTTON);
        html = html.replaceAll(VAR_SWAGGER_THEME, VAL_SWAGGER_THEME);
        return html;
    }

    private String toString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining(NL));
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage getLogo() {
        if (this.whiteLabel.hasLogo()) {
            return this.whiteLabel.getLogo();
        }
        try (InputStream logo = this.getClass().getClassLoader().getResourceAsStream(FILE_LOGO);){
            BufferedImage bufferedImage = ImageIO.read(logo);
            return bufferedImage;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCss() {
        if (this.whiteLabel.hasCss()) {
            return this.whiteLabel.getCss();
        }
        try (InputStream css = this.getClass().getClassLoader().getResourceAsStream(FILE_STYLE);){
            String string = this.toString(css);
            return string;
        }
        catch (IOException ex) {
            return EMPTY;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHTMLTemplate() {
        if (this.whiteLabel.hasHtml()) {
            return this.whiteLabel.getHtml();
        }
        try (InputStream template = this.getClass().getClassLoader().getResourceAsStream(FILE_TEMPLATE);){
            String string = this.toString(template);
            return string;
        }
        catch (IOException ex) {
            return EMPTY;
        }
    }

    private BufferedImage getFavicon(int size, BufferedImage original) {
        int type = original.getType() == 0 ? 2 : original.getType();
        return this.resizeImage(size, original, type);
    }

    private BufferedImage resizeImage(int size, BufferedImage originalImage, int type) {
        BufferedImage resizedImage = new BufferedImage(size, size, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, size, size, null);
        g.dispose();
        return resizedImage;
    }

    private byte[] toBytes(BufferedImage bufferedImage) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, PNG, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] getOriginalLogo() {
        return this.originalLogo;
    }

    public byte[] getFavicon32() {
        return this.favicon32;
    }

    public byte[] getFavicon16() {
        return this.favicon16;
    }

    public String getStyle() {
        return this.style;
    }
}

