/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.imageio.ImageIO;

@ApplicationScoped
public class WhiteLabel {
    private static final Logger log = Logger.getLogger(WhiteLabel.class.getName());
    private final Properties props = new Properties();
    private final String PROPERTIES_FILE_NAME = "apiee.properties";
    private final String LOGO_FILE_NAME = "apiee.png";
    private final String CSS_FILE_NAME = "apiee.css";
    private final String HTML_FILE_NAME = "apiee.html";
    private BufferedImage logo = null;
    private String css = null;
    private String html = null;
    private static final String NL = "\n";

    @PostConstruct
    public void init() {
        Throwable throwable;
        try {
            throwable = null;
            try (InputStream propertiesStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("apiee.properties");){
                if (propertiesStream != null) {
                    this.props.load(propertiesStream);
                } else {
                    log.log(Level.FINEST, "Can not load whilelable properties [apiee.properties]");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | NullPointerException ex) {
            log.log(Level.FINEST, "Can not load whilelable properties [apiee.properties] - {0}", ex.getMessage());
        }
        try {
            throwable = null;
            try (InputStream logoStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("apiee.png");){
                if (logoStream != null) {
                    this.logo = ImageIO.read(logoStream);
                } else {
                    log.log(Level.FINEST, "Can not load whilelable logo [apiee.png]");
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable logo [apiee.png] - {0}", ex.getMessage());
        }
        try {
            throwable = null;
            try (InputStream cssStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("apiee.css");){
                if (cssStream != null) {
                    this.css = this.toString(cssStream);
                } else {
                    log.log(Level.FINEST, "Can not load whilelable css [apiee.css]");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable css [apiee.css] - {0}", ex.getMessage());
        }
        try {
            throwable = null;
            try (InputStream htmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("apiee.html");){
                if (htmlStream != null) {
                    this.html = this.toString(htmlStream);
                } else {
                    log.log(Level.FINEST, "Can not load whilelable html [apiee.html]");
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable html [apiee.html] - {0}", ex.getMessage());
        }
    }

    public boolean hasLogo() {
        return this.logo != null;
    }

    public boolean hasCss() {
        return this.css != null;
    }

    public boolean hasHtml() {
        return this.html != null;
    }

    public boolean hasProperties() {
        return this.props != null && !this.props.isEmpty();
    }

    public String getProperty(String key, String defaultValue) {
        if (this.hasProperties() && this.props.containsKey(key)) {
            return this.props.getProperty(key);
        }
        return defaultValue;
    }

    public Map<String, String> getProperties() {
        if (this.hasProperties()) {
            return new HashMap<Object, Object>(this.props);
        }
        return null;
    }

    private String toString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining(NL));
            return string;
        }
    }

    public BufferedImage getLogo() {
        return this.logo;
    }

    public String getCss() {
        return this.css;
    }

    public String getHtml() {
        return this.html;
    }
}

