/*
 * Decompiled with CFR 0.152.
 */
package com.github.plokhotnyuk.jsoniter_scala.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

class ByteArrayAccess {
    private static final VarHandle VH_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle VH_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle VH_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle VH_INT_REVERSED = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);

    ByteArrayAccess() {
    }

    static void setLong(byte[] byArray, int n, long l) {
        VH_LONG.set(byArray, n, l);
    }

    static long getLong(byte[] byArray, int n) {
        return VH_LONG.get(byArray, n);
    }

    static void setInt(byte[] byArray, int n, int n2) {
        VH_INT.set(byArray, n, n2);
    }

    static int getInt(byte[] byArray, int n) {
        return VH_INT.get(byArray, n);
    }

    static void setShort(byte[] byArray, int n, short s) {
        VH_SHORT.set(byArray, n, s);
    }

    static int getIntReversed(byte[] byArray, int n) {
        return VH_INT_REVERSED.get(byArray, n);
    }
}

