/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.protocol;

import com.github.pukkaone.gelf.protocol.GelfMessage;
import com.github.pukkaone.gelf.protocol.GelfSender;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class GelfTCPSender
extends GelfSender {
    private boolean shutdown;
    private InetAddress host;
    private int port;
    private Socket socket;
    private OutputStreamWriter writer;

    private OutputStreamWriter getWriter() throws IOException {
        if (this.socket == null) {
            this.socket = this.getSocket();
            this.writer = new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8);
        }
        return this.writer;
    }

    protected Socket getSocket() throws IOException {
        return new Socket(this.host, this.port);
    }

    public GelfTCPSender(String host, int port) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown || !message.isValid()) {
            return false;
        }
        try {
            OutputStreamWriter writer = this.getWriter();
            writer.write(message.toJson());
            writer.write(0);
            writer.flush();
            return true;
        }
        catch (IOException e) {
            this.socket = null;
            return false;
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
    }
}

