/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.github.pukkaone.gelf.logback.DefaultGelfMessageFactory;
import com.github.pukkaone.gelf.logback.GelfMessageFactory;
import com.github.pukkaone.gelf.protocol.GelfAMQPSender;
import com.github.pukkaone.gelf.protocol.GelfMessage;
import com.github.pukkaone.gelf.protocol.GelfSSLSender;
import com.github.pukkaone.gelf.protocol.GelfSender;
import com.github.pukkaone.gelf.protocol.GelfTCPSender;
import com.github.pukkaone.gelf.protocol.GelfUDPSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class GelfAppender
extends AppenderBase<ILoggingEvent> {
    private String graylogHost;
    private int graylogPort = 12201;
    private String originHost;
    private boolean levelIncluded = true;
    private boolean locationIncluded;
    private boolean loggerIncluded = true;
    private boolean markerIncluded;
    private boolean mdcIncluded;
    private boolean threadIncluded;
    private String facility = "gelf-java";
    private Map<String, String> additionalFields = new HashMap<String, String>();
    private String amqpURI;
    private String amqpExchange;
    private String amqpRoutingKey;
    private int amqpMaxRetries;
    private boolean sslTrustAllCertificates;
    private GelfMessageFactory marshaller = new DefaultGelfMessageFactory();
    private GelfSender gelfSender;

    public String getGraylogHost() {
        return this.graylogHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    public int getGraylogPort() {
        return this.graylogPort;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    private String getLocalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.addError("Unknown local hostname", e);
        }
        return hostName;
    }

    public String getOriginHost() {
        if (this.originHost == null) {
            this.originHost = this.getLocalHostName();
        }
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    public boolean isLevelIncluded() {
        return this.levelIncluded;
    }

    public void setLevelIncluded(boolean levelIncluded) {
        this.levelIncluded = levelIncluded;
    }

    public boolean isLocationIncluded() {
        return this.locationIncluded;
    }

    public void setLocationIncluded(boolean locationIncluded) {
        this.locationIncluded = locationIncluded;
    }

    public boolean isLoggerIncluded() {
        return this.loggerIncluded;
    }

    public void setLoggerIncluded(boolean loggerIncluded) {
        this.loggerIncluded = loggerIncluded;
    }

    public boolean isMarkerIncluded() {
        return this.markerIncluded;
    }

    public void setMarkerIncluded(boolean markerIncluded) {
        this.markerIncluded = markerIncluded;
    }

    public boolean isMdcIncluded() {
        return this.mdcIncluded;
    }

    public void setMdcIncluded(boolean mdcIncluded) {
        this.mdcIncluded = mdcIncluded;
    }

    public boolean isThreadIncluded() {
        return this.threadIncluded;
    }

    public void setThreadIncluded(boolean threadIncluded) {
        this.threadIncluded = threadIncluded;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void addAdditionalField(String keyValue) {
        String[] parts = keyValue.split("=", 2);
        if (parts.length != 2) {
            this.addError(String.format("additionalField must be in the format key=value, but found [%s]", keyValue));
            return;
        }
        this.additionalFields.put(parts[0], parts[1]);
    }

    public String getAmqpURI() {
        return this.amqpURI;
    }

    public void setAmqpURI(String amqpURI) {
        this.amqpURI = amqpURI;
    }

    public String getAmqpExchange() {
        return this.amqpExchange;
    }

    public void setAmqpExchange(String amqpExchange) {
        this.amqpExchange = amqpExchange;
    }

    public String getAmqpRoutingKey() {
        return this.amqpRoutingKey;
    }

    public void setAmqpRoutingKey(String amqpRoutingKey) {
        this.amqpRoutingKey = amqpRoutingKey;
    }

    public int getAmqpMaxRetries() {
        return this.amqpMaxRetries;
    }

    public void setAmqpMaxRetries(int amqpMaxRetries) {
        this.amqpMaxRetries = amqpMaxRetries;
    }

    public boolean isSslTrustAllCertificates() {
        return this.sslTrustAllCertificates;
    }

    public void setSslTrustAllCertificates(boolean sslTrustAllCertificates) {
        this.sslTrustAllCertificates = sslTrustAllCertificates;
    }

    public GelfMessageFactory getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(GelfMessageFactory marshaller) {
        this.marshaller = marshaller;
    }

    private GelfUDPSender getGelfUDPSender(String graylogHost, int graylogPort) throws IOException {
        return new GelfUDPSender(graylogHost, graylogPort);
    }

    private GelfTCPSender getGelfTCPSender(String graylogHost, int graylogPort) throws IOException {
        return new GelfTCPSender(graylogHost, graylogPort);
    }

    private GelfSSLSender getGelfSSLSender(String graylogHost, int graylogPort, boolean sslTrustAllCertificates) throws IOException {
        return new GelfSSLSender(graylogHost, graylogPort, sslTrustAllCertificates);
    }

    private GelfAMQPSender getGelfAMQPSender(String amqpURI, String amqpExchange, String amqpRoutingKey, int amqpMaxRetries) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        return new GelfAMQPSender(amqpURI, amqpExchange, amqpRoutingKey, amqpMaxRetries);
    }

    public void start() {
        if (this.graylogHost == null && this.amqpURI == null) {
            this.addError("Graylog2 hostname and AMQP URI are empty!");
            return;
        }
        if (this.graylogHost != null && this.amqpURI != null) {
            this.addError("Graylog2 hostname and AMQP URI are both set!");
            return;
        }
        try {
            if (this.graylogHost != null && this.graylogHost.startsWith("ssl:")) {
                String sslGraylogHost = this.graylogHost.substring(4);
                this.gelfSender = this.getGelfSSLSender(sslGraylogHost, this.graylogPort, this.sslTrustAllCertificates);
            } else if (this.graylogHost != null && this.graylogHost.startsWith("tcp:")) {
                String tcpGraylogHost = this.graylogHost.substring(4);
                this.gelfSender = this.getGelfTCPSender(tcpGraylogHost, this.graylogPort);
            } else if (this.graylogHost != null && this.graylogHost.startsWith("udp:")) {
                String udpGraylogHost = this.graylogHost.substring(4);
                this.gelfSender = this.getGelfUDPSender(udpGraylogHost, this.graylogPort);
            } else {
                this.gelfSender = this.amqpURI != null ? this.getGelfAMQPSender(this.amqpURI, this.amqpExchange, this.amqpRoutingKey, this.amqpMaxRetries) : this.getGelfUDPSender(this.graylogHost, this.graylogPort);
            }
        }
        catch (UnknownHostException e) {
            this.addError(String.format("Unknown Graylog2 hostname [%s]", this.getGraylogHost()), e);
            return;
        }
        catch (SocketException e) {
            this.addError("Socket exception", e);
            return;
        }
        catch (IOException e) {
            this.addError("IO exception", e);
            return;
        }
        catch (URISyntaxException e) {
            this.addError(String.format("Invalid AMQP URI [%s]", this.getAmqpURI()), e);
            return;
        }
        catch (NoSuchAlgorithmException e) {
            this.addError("AMQP algorithm exception", e);
            return;
        }
        catch (KeyManagementException e) {
            this.addError("AMQP key exception", e);
            return;
        }
        super.start();
    }

    protected GelfSender getGelfSender() {
        return this.gelfSender;
    }

    protected void append(ILoggingEvent event) {
        GelfMessage message = this.marshaller.createMessage(this, event);
        if (this.getGelfSender() == null || !this.getGelfSender().sendMessage(message)) {
            this.addError("Could not send GELF message");
        }
    }

    public void stop() {
        this.gelfSender.close();
        super.stop();
    }
}

