/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.protocol;

import com.github.pukkaone.gelf.protocol.GelfMessage;
import com.github.pukkaone.gelf.protocol.GelfSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class GelfUDPSender
extends GelfSender {
    private static final int MAXIMUM_CHUNK_SIZE = 1420;
    private static final int MAXIMUM_CHUNKS = 128;
    private static final int HEADER_SIZE = 12;
    private static final int MAXIMUM_DATAGRAM_SIZE = 1432;
    private static final byte[] CHUNKED_ID = new byte[]{30, 15};
    private byte[] hostBytes;
    private InetAddress host;
    private int port;
    private DatagramChannel channel;

    private byte[] hashHostName(String host) {
        return ByteBuffer.allocate(4).putInt(host.hashCode()).array();
    }

    private DatagramChannel initiateChannel() throws IOException {
        DatagramChannel resultingChannel = DatagramChannel.open();
        resultingChannel.socket().bind(new InetSocketAddress(0));
        resultingChannel.connect(new InetSocketAddress(this.host, this.port));
        resultingChannel.configureBlocking(false);
        return resultingChannel;
    }

    public GelfUDPSender(String host, int port) throws IOException {
        this.hostBytes = this.hashHostName(host);
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.channel = this.initiateChannel();
    }

    private void sliceDatagrams(byte[] messageBytes, ByteBuffer[] datagrams) {
        byte[] messageId = ByteBuffer.allocate(8).putInt((int)System.currentTimeMillis()).put(this.hostBytes).array();
        int fromOffset = 0;
        for (int idx = 0; idx < datagrams.length; ++idx) {
            int fromLength = fromOffset + 1420 > messageBytes.length ? messageBytes.length - fromOffset : 1420;
            ByteBuffer datagram = ByteBuffer.allocate(1432).put(CHUNKED_ID).put(messageId).put((byte)idx).put((byte)datagrams.length).put(messageBytes, fromOffset, fromLength);
            datagram.flip();
            datagrams[idx] = datagram;
            fromOffset += 1420;
        }
    }

    private ByteBuffer[] toUDPBuffers(String json) {
        byte[] messageBytes = this.gzipMessage(json);
        int chunksCount = messageBytes.length / 1420;
        if (messageBytes.length % 1420 != 0) {
            ++chunksCount;
        }
        if (chunksCount > 128) {
            chunksCount = 128;
        }
        ByteBuffer[] datagrams = new ByteBuffer[chunksCount];
        if (messageBytes.length > 1420) {
            this.sliceDatagrams(messageBytes, datagrams);
        } else {
            datagrams[0] = ByteBuffer.allocate(messageBytes.length);
            datagrams[0].put(messageBytes);
            datagrams[0].flip();
        }
        return datagrams;
    }

    private boolean sendDatagrams(ByteBuffer[] buffers) {
        try {
            for (ByteBuffer buffer : buffers) {
                this.channel.write(buffer);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        return message.isValid() && this.sendDatagrams(this.toUDPBuffers(message.toJson()));
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

