/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.tools.AbstractSoapUIRunner;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiMojo;

public abstract class AbstractSoapuiRunnerMojo
extends AbstractSoapuiMojo {
    private String[] globalProperties;
    private String projectFile;
    private String projectPassword;
    private String[] projectProperties;
    protected boolean saveAfterRun;
    private String settingsFile;
    private String settingsPassword;
    private boolean skip;
    private Properties soapuiProperties;
    protected String runnerType;

    @Override
    protected void performExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            this.getLog().info((CharSequence)"SoapUI execution is skipped.");
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        this.performRunnerExecute();
    }

    protected abstract void performRunnerExecute() throws MojoExecutionException, MojoFailureException;

    protected void configureWithSharedParameters(AbstractSoapUIRunner runner) {
        runner.setProjectFile(this.projectFile);
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && !this.soapuiProperties.isEmpty()) {
            for (Object keyObject : this.soapuiProperties.keySet()) {
                String key = (String)keyObject;
                this.getLog().info((CharSequence)("Setting " + key + " value " + this.soapuiProperties.getProperty(key)));
                System.setProperty(key, this.soapuiProperties.getProperty(key));
            }
        }
    }
}

