/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.SoapUIProMockAsWarGenerator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiRunnerMojo;
import org.ktc.soapui.maven.extension.impl.ProjectInfo;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;

public class MockAsWarMojo
extends AbstractSoapuiRunnerMojo {
    private File warFile;
    private File explodedWarDirectory;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;

    @Override
    protected void performRunnerExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Running Mock As War");
        SoapUIProMockAsWarGenerator runner = new SoapUIProMockAsWarGenerator();
        this.configureWithSharedParameters((AbstractSoapUIRunner)runner);
        try {
            this.buildSoapuiGuiEnvironment();
            this.explodedWarDirectory.mkdirs();
            runner.setOutputFolder(this.explodedWarDirectory.getAbsolutePath());
            this.warFile.getParentFile().mkdirs();
            runner.setWarFile(this.warFile.getAbsolutePath());
            runner.run();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
    }

    private void buildSoapuiGuiEnvironment() throws DependencyResolutionException, IOException {
        this.getLog().info((CharSequence)"Building a Soapui Gui environment");
        String version = ProjectInfo.getVersion();
        File soapuiLibDirectory = this.getBuiltSoapuiGuiLibDirectory();
        this.resolveAndCopyDependencies(new DefaultArtifact("com.github.redfish4ktc.soapui:maven-soapui-extension-plugin:" + version), soapuiLibDirectory);
        File soapuiBinDirectory = this.getBuiltSoapuiGuiBinDirectory();
        this.copySoapuiJar(soapuiLibDirectory, soapuiBinDirectory);
        System.setProperty("soapui.home", soapuiBinDirectory.getAbsolutePath());
        this.getLog().info((CharSequence)"Soapui Gui environment built");
    }

    private void resolveAndCopyDependencies(DefaultArtifact rootArtifact, File soapuiLibDirectory) throws DependencyResolutionException, IOException {
        this.getLog().info((CharSequence)("Resolving artifact " + rootArtifact + " from " + this.remoteRepos));
        List results = this.repoSystem.resolveDependencies(this.repoSession, this.newDependencyRequest(rootArtifact)).getArtifactResults();
        this.getLog().info((CharSequence)("Artifact resolved with transitive dependencies: " + results.size()));
        this.getLog().info((CharSequence)("Copying artifacts to " + soapuiLibDirectory));
        for (ArtifactResult result : results) {
            File artifactFile = result.getArtifact().getFile();
            File ouputFile = new File(soapuiLibDirectory, artifactFile.getName());
            FileUtils.copyFile((File)artifactFile, (File)ouputFile);
        }
        this.getLog().info((CharSequence)"Copy done");
    }

    private void copySoapuiJar(File sourceDirectory, File destinationDirectory) throws IOException {
        this.getLog().info((CharSequence)("Copying soapui jar to " + destinationDirectory));
        File[] mainJars = sourceDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("soapui") && name.toLowerCase().endsWith(".jar");
            }
        });
        if (mainJars.length == 0) {
            throw new RuntimeException("Unable to found a soapui jar in " + sourceDirectory);
        }
        File soapuiSourceJar = mainJars[0];
        FileUtils.copyFileToDirectory((File)soapuiSourceJar, (File)destinationDirectory);
        this.getLog().info((CharSequence)"Copy done");
    }

    private File getBuiltSoapuiGuiLibDirectory() {
        return new File(this.getBuiltSoapuiGuiHomeDirectory(), "lib");
    }

    private File getBuiltSoapuiGuiBinDirectory() {
        return new File(this.getBuiltSoapuiGuiHomeDirectory(), "bin");
    }

    private String getBuiltSoapuiGuiHomeDirectory() {
        Build build = this.project.getBuild();
        return build.getDirectory() + "/soapui/home";
    }

    private List<RemoteRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    private DependencyRequest newDependencyRequest(DefaultArtifact artifact) {
        return new DependencyRequest(this.newRequest(new Dependency((Artifact)artifact, "runtime")), DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}));
    }

    private CollectRequest newRequest(Dependency root) {
        CollectRequest request = new CollectRequest();
        request.setRoot(root);
        request.setRepositories(this.getRemoteRepos());
        return request;
    }
}

