/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.tools.SoapUITestCaseRunner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.ktc.soapui.maven.extension.TestMojo;
import org.ktc.soapui.maven.extension.impl.runner.SoapUITestCaseRunnerWrapper;

public class TestMultiMojo
extends TestMojo {
    private List<ProjectFilesScan> projectFiles;
    private boolean useOutputFolderPerProject;

    @Override
    protected void performRunnerExecute() throws MojoExecutionException, MojoFailureException {
        List<File> resolvedProjectFiles = this.resolveProjectFiles();
        for (File currentProjectFile : resolvedProjectFiles) {
            this.configureAndRun(SoapUITestCaseRunnerWrapper.newSoapUITestCaseRunnerWrapper(this.runnerType), currentProjectFile.getAbsolutePath());
        }
    }

    @Override
    protected void configureOuputFolder(SoapUITestCaseRunner runner, String currentProjectFile) {
        if (this.useOutputFolderPerProject) {
            String projectFileName = FilenameUtils.getBaseName((String)currentProjectFile);
            File projectOuputFolder = new File(this.outputFolder, projectFileName);
            runner.setOutputFolder(projectOuputFolder.getAbsolutePath());
        } else {
            super.configureOuputFolder(runner, currentProjectFile);
        }
    }

    private List<File> resolveProjectFiles() {
        ArrayList<File> resolved = new ArrayList<File>();
        for (ProjectFilesScan scan : this.projectFiles) {
            DirectoryScanner scanner = new DirectoryScanner();
            File baseDirectory = scan.baseDirectory;
            scanner.setBasedir(baseDirectory);
            if (scan.includes != null) {
                scanner.setIncludes(TestMultiMojo.toArray(scan.includes));
            }
            scanner.setExcludes(TestMultiMojo.toArray(scan.excludes));
            scanner.scan();
            for (String includedFile : scanner.getIncludedFiles()) {
                resolved.add(new File(baseDirectory, includedFile));
            }
            for (String includedDirectory : scanner.getIncludedDirectories()) {
                resolved.add(new File(baseDirectory, includedDirectory));
            }
        }
        return resolved;
    }

    private static String[] toArray(Set<String> set) {
        return set == null ? null : set.toArray(new String[set.size()]);
    }

    public static class ProjectFilesScan {
        public File baseDirectory;
        public Set<String> includes;
        public Set<String> excludes;
    }
}

