/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.tools.AbstractSoapUIRunner;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiMojo;

public abstract class AbstractSoapuiRunnerMojo
extends AbstractSoapuiMojo {
    private String[] globalProperties;
    protected String outputFolder;
    protected String projectFile;
    private String projectPassword;
    private String[] projectProperties;
    protected boolean saveAfterRun;
    private String settingsFile;
    private String settingsPassword;
    private boolean skip;
    private Properties soapuiProperties;
    protected String runnerType;

    @Override
    protected void performExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            this.getLog().info((CharSequence)"SoapUI execution is skipped.");
            return;
        }
        this.performRunnerExecute();
    }

    protected abstract void performRunnerExecute() throws MojoExecutionException, MojoFailureException;

    protected void configureWithSharedParameters(AbstractSoapUIRunner runner) {
        this.configureWithSharedParameters(runner, this.projectFile);
    }

    protected void configureWithSharedParameters(AbstractSoapUIRunner runner, String currentProjectFile) {
        runner.setProjectFile(currentProjectFile);
        runner.setProjectPassword(this.projectPassword);
        runner.setSettingsFile(this.settingsFile);
        runner.setSoapUISettingsPassword(this.settingsPassword);
        runner.setGlobalProperties(ArrayUtils.nullToEmpty((String[])this.globalProperties));
        runner.setProjectProperties(ArrayUtils.nullToEmpty((String[])this.projectProperties));
        this.initializeSystemProperties();
    }

    private void initializeSystemProperties() {
        if (!AbstractSoapuiRunnerMojo.isNullOrEmpty(this.soapuiProperties)) {
            for (Object keyObject : this.soapuiProperties.keySet()) {
                String key = (String)keyObject;
                this.getLog().info((CharSequence)("Setting " + key + " value " + this.soapuiProperties.getProperty(key)));
                System.setProperty(key, this.soapuiProperties.getProperty(key));
            }
        }
    }

    private static boolean isNullOrEmpty(Properties props) {
        return props == null || props.isEmpty();
    }
}

