/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.AbstractEvent;
import com.novocode.junit.Ansi;
import com.novocode.junit.OutputCapture;
import com.novocode.junit.RichLogger;
import com.novocode.junit.RunSettings;
import com.novocode.junit.RunStatistics;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Status;

final class EventDispatcher
extends RunListener {
    private final RichLogger logger;
    private final Set<String> reported = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<String, Long> startTimes = new ConcurrentHashMap();
    private final EventHandler handler;
    private final RunSettings settings;
    private final Fingerprint fingerprint;
    private final String taskInfo;
    private final RunStatistics runStatistics;
    private OutputCapture capture;

    EventDispatcher(RichLogger richLogger, EventHandler eventHandler, RunSettings runSettings, Fingerprint fingerprint, Description description, RunStatistics runStatistics) {
        this.logger = richLogger;
        this.handler = eventHandler;
        this.settings = runSettings;
        this.fingerprint = fingerprint;
        this.taskInfo = runSettings.buildInfoName(description);
        this.runStatistics = runStatistics;
    }

    public void testAssumptionFailure(Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new ErrorEvent(failure, Status.Skipped){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.warn("Test assumption in test " + this.ansiName + " failed: " + this.ansiMsg + this.durationSuffix());
            }
        });
    }

    public void testFailure(Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new ErrorEvent(failure, Status.Failure){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.error("Test " + this.ansiName + " failed: " + this.ansiMsg + this.durationSuffix(), this.error);
            }
        });
    }

    public void testFinished(Description description) {
        this.uncapture(false);
        this.postIfFirst(new InfoEvent(description, Status.Success){

            @Override
            void logTo(RichLogger richLogger) {
                EventDispatcher.this.debugOrInfo("Test " + this.ansiName + " finished" + this.durationSuffix(), RunSettings.Verbosity.TEST_FINISHED);
            }
        });
        this.logger.popCurrentTestClassName();
    }

    public void testIgnored(Description description) {
        this.postIfFirst(new InfoEvent(description, Status.Ignored){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.info("Test " + this.ansiName + " ignored");
            }
        });
    }

    public void testStarted(Description description) {
        this.recordStartTime(description);
        this.logger.pushCurrentTestClassName(description.getClassName());
        this.debugOrInfo("Test " + this.settings.buildInfoName(description) + " started", RunSettings.Verbosity.STARTED);
        this.capture();
    }

    private void recordStartTime(Description description) {
        this.startTimes.putIfAbsent(this.settings.buildPlainName(description), System.currentTimeMillis());
    }

    private Long elapsedTime(Description description) {
        Long l = this.startTimes.get(this.settings.buildPlainName(description));
        if (l == null) {
            return 0L;
        }
        return System.currentTimeMillis() - l;
    }

    public void testRunFinished(Result result) {
        this.debugOrInfo(Ansi.c("Test run ", "\u001b[34m") + this.taskInfo + Ansi.c(" finished: ", "\u001b[34m") + Ansi.c(result.getFailureCount() + " failed", result.getFailureCount() > 0 ? "\u001b[31m" : "\u001b[34m") + Ansi.c(", ", "\u001b[34m") + Ansi.c(result.getIgnoreCount() + " ignored", result.getIgnoreCount() > 0 ? "\u001b[33m" : "\u001b[34m") + Ansi.c(", " + result.getRunCount() + " total, " + (double)result.getRunTime() / 1000.0 + "s", "\u001b[34m"), RunSettings.Verbosity.RUN_FINISHED);
        this.runStatistics.addTime(result.getRunTime());
    }

    public void testRunStarted(Description description) {
        this.debugOrInfo(Ansi.c("Test run ", "\u001b[34m") + this.taskInfo + Ansi.c(" started", "\u001b[34m"), RunSettings.Verbosity.STARTED);
    }

    void testExecutionFailed(String string, Throwable throwable) {
        this.post(new Event(Ansi.c(string, "\u001b[31m"), this.settings.buildErrorMessage(throwable), Status.Error, (Long)0L, throwable){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.error("Execution of test " + this.ansiName + " failed: " + this.ansiMsg, this.error);
            }
        });
    }

    private void postIfFirst(AbstractEvent abstractEvent) {
        boolean bl;
        abstractEvent.logTo(this.logger);
        String string = abstractEvent.fullyQualifiedName();
        if (this.reported.add(string)) {
            this.runStatistics.captureStats(abstractEvent);
            this.handler.handle((sbt.testing.Event)abstractEvent);
        }
        boolean bl2 = bl = abstractEvent.status == Status.Success || abstractEvent.status == Status.Skipped || abstractEvent.status == Status.Ignored;
        if (bl) {
            this.reported.remove(string);
        }
    }

    private void post(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        this.runStatistics.captureStats(abstractEvent);
        this.handler.handle((sbt.testing.Event)abstractEvent);
    }

    private void capture() {
        if (this.settings.quiet && this.capture == null) {
            this.capture = OutputCapture.start();
        }
    }

    void uncapture(boolean bl) {
        if (this.settings.quiet && this.capture != null) {
            this.capture.stop();
            if (bl) {
                try {
                    this.capture.replay();
                }
                catch (IOException iOException) {
                    this.logger.error("Error replaying captured stdio", iOException);
                }
            }
            this.capture = null;
        }
    }

    private void debugOrInfo(String string, RunSettings.Verbosity verbosity) {
        if (verbosity.ordinal() <= this.settings.verbosity.ordinal()) {
            this.logger.info(string);
        } else {
            this.logger.debug(string);
        }
    }

    private abstract class InfoEvent
    extends Event {
        InfoEvent(Description description, Status status) {
            super(EventDispatcher.this.settings.buildInfoName(description), null, status, EventDispatcher.this.elapsedTime(description), null);
        }
    }

    private abstract class ErrorEvent
    extends Event {
        ErrorEvent(Failure failure, Status status) {
            super(EventDispatcher.this.settings.buildErrorName(failure.getDescription()), EventDispatcher.this.settings.buildErrorMessage(failure.getException()), status, EventDispatcher.this.elapsedTime(failure.getDescription()), failure.getException());
        }
    }

    private abstract class Event
    extends AbstractEvent {
        Event(String string, String string2, Status status, Long l, Throwable throwable) {
            super(string, string2, status, EventDispatcher.this.fingerprint, l, throwable);
        }

        String durationSuffix() {
            return ", took " + this.durationToString();
        }
    }
}

