/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.AbstractEvent;
import com.novocode.junit.RunSettings;
import java.util.ArrayList;
import java.util.List;
import sbt.testing.Status;

class RunStatistics {
    private final RunSettings settings;
    private int failedCount;
    private int ignoredCount;
    private int otherCount;
    private final ArrayList<String> failedNames = new ArrayList();
    private volatile long accumulatedTime;

    RunStatistics(RunSettings runSettings) {
        this.settings = runSettings;
    }

    void addTime(long l) {
        this.accumulatedTime += l;
    }

    synchronized void captureStats(AbstractEvent abstractEvent) {
        Status status = abstractEvent.status();
        if (status == Status.Error || status == Status.Failure) {
            ++this.failedCount;
            this.failedNames.add(abstractEvent.fullyQualifiedName());
        } else if (status == Status.Ignored) {
            ++this.ignoredCount;
        } else {
            ++this.otherCount;
        }
    }

    private String summaryLine() {
        return (this.failedCount == 0 ? "All tests passed: " : "Some tests failed: ") + this.failedCount + " failed, " + this.ignoredCount + " ignored, " + (this.failedCount + this.ignoredCount + this.otherCount) + " total, " + (double)this.accumulatedTime / 1000.0 + "s";
    }

    private static String mkString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    synchronized String createSummary() {
        switch (this.settings.summary) {
            case LIST_FAILED: {
                return this.failedNames.isEmpty() ? this.summaryLine() : this.summaryLine() + "\n- Failed tests: " + RunStatistics.mkString(this.failedNames);
            }
            case ONE_LINE: {
                return this.summaryLine();
            }
        }
        return "";
    }
}

