/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;

public class MultipleVariableDeclarationsExtendedCheck
extends AbstractCheck {
    public static final String MSG_VAR_DECLARATIONS_COMMA = "multiple.variable.declarations.comma";
    public static final String MSG_VAR_DECLARATIONS = "multiple.variable.declarations";
    private boolean ignoreCycles;
    private boolean ignoreMethods;

    public void setIgnoreCycles(boolean value) {
        this.ignoreCycles = value;
    }

    public void setIgnoreMethods(boolean value) {
        this.ignoreMethods = value;
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void work(DetailAST ast) {
        DetailAST nextNode = ast.getNextSibling();
        if (nextNode != null) {
            boolean isCommaSeparated;
            boolean bl = isCommaSeparated = nextNode.getType() == 74;
            if (nextNode.getType() == 74 || nextNode.getType() == 45) {
                nextNode = nextNode.getNextSibling();
            }
            if (nextNode != null && nextNode.getType() == 10) {
                DetailAST firstNode = CheckUtil.getFirstNode((DetailAST)ast);
                if (isCommaSeparated) {
                    this.log(firstNode, MSG_VAR_DECLARATIONS_COMMA, new Object[0]);
                } else {
                    DetailAST lastNode = MultipleVariableDeclarationsExtendedCheck.getLastNode(ast);
                    DetailAST firstNextNode = CheckUtil.getFirstNode((DetailAST)nextNode);
                    if (firstNextNode.getLineNo() == lastNode.getLineNo()) {
                        this.log(firstNode, MSG_VAR_DECLARATIONS, new Object[0]);
                    }
                }
            }
        }
    }

    public void visitToken(DetailAST ast) {
        boolean inClass;
        DetailAST token = ast;
        boolean inFor = ast.getParent().getType() == 35;
        boolean bl = inClass = ast.getParent().getParent().getType() == 14;
        if (inClass) {
            this.work(token);
        } else if (!this.ignoreCycles && inFor) {
            this.work(token);
        } else if (!this.ignoreMethods && !inFor) {
            this.work(token);
        }
    }

    private static DetailAST getLastNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = MultipleVariableDeclarationsExtendedCheck.getLastNode(child);
            if (newNode.getLineNo() <= currentNode.getLineNo() || newNode.getColumnNo() <= currentNode.getColumnNo()) continue;
            currentNode = newNode;
        }
        return currentNode;
    }
}

