/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.LinkedList;
import java.util.List;

public class TernaryPerExpressionCountCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ternary.per.expression.count";
    private static final int DEFAULT_MAX_TERNARY_PER_EXPRESSION_COUNT = 1;
    private int maxTernaryPerExpressionCount = 1;
    private boolean ignoreTernaryOperatorsInBraces = true;
    private boolean ignoreIsolatedTernaryOnLine = true;

    public int[] getDefaultTokens() {
        return new int[]{28};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setMaxTernaryPerExpressionCount(int maxTernaryPerExpressionCount) {
        if (maxTernaryPerExpressionCount < 0) {
            throw new IllegalArgumentException("Value should be 0 or more then 0");
        }
        this.maxTernaryPerExpressionCount = maxTernaryPerExpressionCount;
    }

    public void setIgnoreTernaryOperatorsInBraces(boolean ignoreTernaryOperatorsInBraces) {
        this.ignoreTernaryOperatorsInBraces = ignoreTernaryOperatorsInBraces;
    }

    public void setIgnoreIsolatedTernaryOnLine(boolean ignoreIsolatedTernaryOnLine) {
        this.ignoreIsolatedTernaryOnLine = ignoreIsolatedTernaryOnLine;
    }

    public void visitToken(DetailAST expressionNode) {
        List<DetailAST> questionNodes = this.getQuestionNodes(expressionNode);
        if (questionNodes.size() > this.maxTernaryPerExpressionCount) {
            DetailAST firstQuestionNode = questionNodes.get(0);
            this.log(firstQuestionNode, MSG_KEY, new Object[]{this.maxTernaryPerExpressionCount});
        }
    }

    private List<DetailAST> getQuestionNodes(DetailAST expressionNode) {
        LinkedList<DetailAST> questionNodes = new LinkedList<DetailAST>();
        DetailAST currentNode = expressionNode;
        do {
            if ((currentNode = TernaryPerExpressionCountCheck.getNextNode(expressionNode, currentNode)) == null || currentNode.getType() != 109 || this.isSkipTernaryOperator(currentNode)) continue;
            questionNodes.add(currentNode);
        } while (currentNode != null);
        return questionNodes;
    }

    private boolean isSkipTernaryOperator(DetailAST questionAST) {
        return this.ignoreTernaryOperatorsInBraces && TernaryPerExpressionCountCheck.isTernaryOperatorInBraces(questionAST) || this.ignoreIsolatedTernaryOnLine && this.isIsolatedTernaryOnLine(questionAST);
    }

    private static boolean isTernaryOperatorInBraces(DetailAST questionAST) {
        return questionAST.getPreviousSibling() != null && questionAST.getPreviousSibling().getType() == 76;
    }

    private boolean isIsolatedTernaryOnLine(DetailAST questionAST) {
        int lineNo = questionAST.getLineNo() - 1;
        String line = this.getFileContents().getText().get(lineNo);
        return this.isSingleTernaryLine(line, lineNo);
    }

    private boolean isSingleTernaryLine(String line, int lineNo) {
        int questionsPerLine = 0;
        char[] charArrayFromLine = line.toCharArray();
        for (int index = 0; index < line.length(); ++index) {
            char currentSymbol = charArrayFromLine[index];
            if (currentSymbol == '?' && !this.getFileContents().hasIntersectionWithComment(lineNo + 1, index, lineNo + 1, index)) {
                ++questionsPerLine;
            }
            if (questionsPerLine > 1) break;
        }
        return questionsPerLine == 1;
    }

    private static DetailAST getNextNode(DetailAST expressionNode, DetailAST node) {
        DetailAST currentNode = node;
        DetailAST toVisit = currentNode.getFirstChild();
        while (toVisit == null && currentNode != expressionNode) {
            toVisit = currentNode.getNextSibling();
            if (toVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return toVisit;
    }
}

