/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AvoidConditionInversionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.condition.inversion";
    private static final Set<Integer> RELATIONAL_OPERATORS_SET = Set.of(Integer.valueOf(117), Integer.valueOf(119), Integer.valueOf(118), Integer.valueOf(120), Integer.valueOf(116), Integer.valueOf(115));
    private static final Set<Integer> RELATIONAL_AND_CONDITIONAL_OPERATORS_SET = Stream.concat(RELATIONAL_OPERATORS_SET.stream(), Stream.of(110, 111)).collect(Collectors.toUnmodifiableSet());
    private boolean applyOnlyToRelationalOperands;

    public void setApplyOnlyToRelationalOperands(boolean applyOnlyToRelationalOperands) {
        this.applyOnlyToRelationalOperands = applyOnlyToRelationalOperands;
    }

    public int[] getDefaultTokens() {
        return new int[]{88, 83, 84, 85, 36};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST expressionAst = ast.findFirstToken(28);
        switch (ast.getType()) {
            case 88: {
                DetailAST inversionAst;
                if (AvoidConditionInversionCheck.isEmptyReturn(ast) || !this.isAvoidableInversion(inversionAst = AvoidConditionInversionCheck.getInversion(expressionAst))) break;
                this.log(inversionAst);
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                DetailAST invertedAst = AvoidConditionInversionCheck.getInversion(expressionAst);
                if (!this.isAvoidableInversion(invertedAst)) break;
                this.log(invertedAst);
                break;
            }
            case 36: {
                DetailAST inversionAst;
                if (AvoidConditionInversionCheck.isEmptyForCondition(ast) || !this.isAvoidableInversion(inversionAst = AvoidConditionInversionCheck.getInversion(expressionAst))) break;
                this.log(inversionAst);
                break;
            }
            default: {
                SevntuUtil.reportInvalidToken(ast.getType());
            }
        }
    }

    private static boolean isEmptyReturn(DetailAST returnAst) {
        return returnAst.findFirstToken(28) == null;
    }

    private static boolean isEmptyForCondition(DetailAST forConditionAst) {
        return forConditionAst.getFirstChild() == null;
    }

    private static DetailAST getInversion(DetailAST expressionAst) {
        return expressionAst.findFirstToken(132);
    }

    private boolean isAvoidableInversion(DetailAST inversionAst) {
        return inversionAst != null && !this.isSkipCondition(inversionAst);
    }

    private boolean isSkipCondition(DetailAST inversionConditionAst) {
        return this.applyOnlyToRelationalOperands && !AvoidConditionInversionCheck.containsRelationalOperandsOnly(inversionConditionAst) || !AvoidConditionInversionCheck.containsConditionalOrRelationalOperands(inversionConditionAst);
    }

    private static boolean containsRelationalOperandsOnly(DetailAST inversionConditionAst) {
        boolean result = true;
        DetailAST operatorInInversionAst = inversionConditionAst.getFirstChild().getNextSibling();
        if (operatorInInversionAst != null && !RELATIONAL_OPERATORS_SET.contains(operatorInInversionAst.getType())) {
            for (DetailAST currentNode = operatorInInversionAst.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (currentNode.getType() != 58 && AvoidConditionInversionCheck.isRelationalOperand(currentNode)) continue;
                result = false;
            }
        }
        return result;
    }

    private static boolean isRelationalOperand(DetailAST operandAst) {
        return operandAst.getFirstChild() == null || RELATIONAL_OPERATORS_SET.contains(operandAst.getType());
    }

    private static boolean containsConditionalOrRelationalOperands(DetailAST inversionAst) {
        boolean result = false;
        for (DetailAST currentNodeAst = inversionAst.getFirstChild(); currentNodeAst != null; currentNodeAst = currentNodeAst.getNextSibling()) {
            if (!RELATIONAL_AND_CONDITIONAL_OPERATORS_SET.contains(currentNodeAst.getType())) continue;
            result = true;
        }
        return result;
    }

    private void log(DetailAST inversionAst) {
        this.log(inversionAst, MSG_KEY, new Object[0]);
    }
}

