/*
 * Decompiled with CFR 0.152.
 */
package com.github.sftwnd.crayfish.alarms.service;

import com.github.sftwnd.crayfish.alarms.service.AbstractAlarmProcessor;
import com.github.sftwnd.crayfish.alarms.service.IAlarmService;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public abstract class AlarmService<M, R>
extends AbstractAlarmProcessor<R>
implements IAlarmService<M, R> {
    @Generated
    private static final Logger logger = Logger.getLogger(AlarmService.class.getName());
    private static final long DEFAULT_MINIMAL_WAIT_NANOS = Duration.ofMillis(75L).toNanos();
    private final ConcurrentLinkedQueue<RegistrationRequest> registrationQueue = new ConcurrentLinkedQueue();
    private final long minimalWaitNanos;
    private final AtomicBoolean syncFlag = new AtomicBoolean(false);
    private final AtomicBoolean processFlag = new AtomicBoolean(false);

    protected AlarmService(@Nullable Duration minimalWait) {
        this.minimalWaitNanos = Optional.ofNullable(minimalWait).map(Duration::toNanos).map(nanos -> Math.max(0L, nanos)).orElse(DEFAULT_MINIMAL_WAIT_NANOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Collection<M>> addElements(@NonNull Collection<M> elements) {
        if (!elements.isEmpty()) {
            RegistrationRequest registrationRequest = this.registrationRequest(elements);
            if (this.syncFlag.get()) {
                ConcurrentLinkedQueue<RegistrationRequest> concurrentLinkedQueue = this.registrationQueue;
                synchronized (concurrentLinkedQueue) {
                    if (this.syncFlag.compareAndSet(true, false)) {
                        this.registrationQueue.add(registrationRequest);
                        this.registrationQueue.notifyAll();
                        return registrationRequest.getCompletableFuture().minimalCompletionStage();
                    }
                }
            }
            this.registrationQueue.add(registrationRequest);
            return registrationRequest.getCompletableFuture().minimalCompletionStage();
        }
        CompletableFuture result = new CompletableFuture();
        result.complete(Collections.emptyList());
        return result.minimalCompletionStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(@NonNull Consumer<Collection<R>> consumer, @Nullable Supplier<Duration> timeOffset) {
        if (!this.processFlag.compareAndSet(false, true)) {
            throw new IllegalStateException("AlarmTimeRangeService already in process");
        }
        super.process(consumer, timeOffset);
        try {
            this.processLoop(consumer);
        }
        catch (InterruptedException itrex) {
            logger.log(Level.WARNING, "AlarmService::process is terminated by cause: {0}", Optional.ofNullable(itrex.getLocalizedMessage()).orElseGet(() -> String.valueOf(itrex)));
            Thread.currentThread().interrupt();
        }
        finally {
            this.registrationQueue.forEach(rec$ -> ((RegistrationRequest)rec$).reject());
            this.processFlag.set(false);
        }
    }

    protected abstract boolean isComplete();

    protected abstract void processFiredElements(Consumer<Collection<R>> var1);

    protected abstract Duration durationToFirstAlarm(Instant var1);

    protected abstract Collection<M> registerElements(@NonNull Collection<M> var1);

    private void processLoop(Consumer<Collection<R>> consumer) throws InterruptedException {
        while (!this.isComplete()) {
            this.processFiredElements(consumer);
            Instant now = Instant.now();
            this.register(now.plus(this.durationToFirstAlarm(now.plusNanos(this.getTimeOffsetNanos()))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RegistrationRequest syncNext(Instant until) throws InterruptedException {
        RegistrationRequest next = this.registrationQueue.poll();
        if (next == null) {
            boolean needNext = false;
            ConcurrentLinkedQueue<RegistrationRequest> concurrentLinkedQueue = this.registrationQueue;
            synchronized (concurrentLinkedQueue) {
                this.syncFlag.compareAndSet(false, true);
                try {
                    next = this.registrationQueue.poll();
                    if (next == null) {
                        long waitNanos = Duration.between(Instant.now(), until).toNanos();
                        if (waitNanos > this.minimalWaitNanos) {
                            this.registrationQueue.wait(waitNanos / 1000000L, (int)(waitNanos % 1000000L));
                        }
                        needNext = waitNanos > 0L;
                    }
                }
                finally {
                    this.syncFlag.set(false);
                }
            }
            if (needNext) {
                next = this.registrationQueue.poll();
            }
        }
        return next;
    }

    private void register(Instant until) throws InterruptedException {
        Instant instant = Instant.MIN;
        while (instant.isBefore(until) && !Optional.ofNullable(this.syncNext(until)).map(rec$ -> ((RegistrationRequest)rec$).apply()).orElse(false).booleanValue()) {
            instant = Instant.now();
        }
    }

    private RegistrationRequest registrationRequest(@NonNull Collection<M> elements) {
        return new RegistrationRequest(new CompletableFuture(), Objects.requireNonNull(elements, "RegistrationRequest::new - elements is null"));
    }

    private class RegistrationRequest {
        private final CompletableFuture<Collection<M>> completableFuture;
        private final Collection<M> elements;

        private boolean apply() {
            Collection rejected = AlarmService.this.registerElements(this.elements);
            this.completableFuture.complete(rejected);
            return this.elements.size() - rejected.size() > 0;
        }

        private void reject() {
            this.completableFuture.complete(this.elements);
        }

        @Generated
        private RegistrationRequest(CompletableFuture<Collection<M>> completableFuture, Collection<M> elements) {
            this.completableFuture = completableFuture;
            this.elements = elements;
        }

        @Generated
        public CompletableFuture<Collection<M>> getCompletableFuture() {
            return this.completableFuture;
        }

        @Generated
        public Collection<M> getElements() {
            return this.elements;
        }
    }
}

