/*
 * Decompiled with CFR 0.152.
 */
package com.github.sftwnd.crayfish.alarms.service;

import com.github.sftwnd.crayfish.alarms.service.AlarmService;
import com.github.sftwnd.crayfish.alarms.timerange.ITimeRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import lombok.Generated;

public class AlarmTimeRangeService<M, R>
extends AlarmService<M, R> {
    @Generated
    private static final Logger logger = Logger.getLogger(AlarmTimeRangeService.class.getName());
    private final ITimeRange<M, R> timeRange;

    public AlarmTimeRangeService(@NonNull ITimeRange<M, R> timeRange, @Nullable Duration minimalWait) {
        super(minimalWait);
        this.timeRange = Objects.requireNonNull(timeRange, "AlarmTimeRangeService::new - timeRange is null");
    }

    @Override
    protected boolean isComplete() {
        return this.timeRange.isComplete(Instant.now().plusNanos(this.getTimeOffsetNanos()));
    }

    @Override
    protected void processFiredElements(Consumer<Collection<R>> consumer) {
        Optional.of(this.timeRange.extractFiredElements(Instant.now().plusNanos(this.getTimeOffsetNanos()))).filter(Predicate.not(Collection::isEmpty)).ifPresent(consumer);
    }

    @Override
    protected Duration durationToFirstAlarm(Instant fromInstant) {
        return this.timeRange.duration(fromInstant);
    }

    @Override
    protected Collection<M> registerElements(@NonNull Collection<M> elements) {
        return this.timeRange.addElements(elements);
    }
}

