/*
 * Decompiled with CFR 0.152.
 */
package com.github.sftwnd.crayfish.alarms.service;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface IAlarmProcessor<R> {
    public void process(@NonNull Consumer<Collection<R>> var1, @Nullable Supplier<Duration> var2);

    default public void singleProcess(@NonNull Consumer<R> consumer, @Nullable Supplier<Duration> timeOffset) {
        Objects.requireNonNull(consumer, "IAlarmProcessor::singleProcess - consumer is null");
        this.process((Collection<R> collection) -> collection.forEach(consumer), timeOffset);
    }

    default public void process(@NonNull Consumer<Collection<R>> consumer, @Nullable Duration timeOffset) {
        this.process(consumer, () -> timeOffset);
    }

    default public void singleProcess(@NonNull Consumer<R> consumer, @Nullable Duration timeOffset) {
        this.singleProcess(consumer, () -> timeOffset);
    }

    default public void process(@NonNull Consumer<Collection<R>> consumer) {
        this.process(consumer, Duration.ZERO);
    }

    default public void singleProcess(@NonNull Consumer<R> consumer) {
        this.singleProcess(consumer, Duration.ZERO);
    }
}

