/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.core;

import com.github.shyiko.ktlint.core.KtLint;
import com.github.shyiko.ktlint.core.LintError;
import com.github.shyiko.ktlint.core.ParseException;
import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.core.RuleExecutionException;
import com.github.shyiko.ktlint.core.RuleSet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.PomModelAspect;
import org.jetbrains.kotlin.com.intellij.pom.PomTransaction;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelListener;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeCopyHandler;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import sun.reflect.ReflectionFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003#$%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J(\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J(\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u000e0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J6\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0\u0004J0\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u000bJ\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!H\u0002J \u0010\"\u001a\u00020\u001d*\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/github/shyiko/ktlint/core/KtLint;", "", "()V", "nullSuppression", "Lkotlin/Function2;", "", "", "", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "calculateLineBreakOffset", "Lkotlin/Function1;", "fileContent", "calculateLineColByOffset", "Lkotlin/Pair;", "text", "calculateSuppressedRegions", "rootNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "determineLineSeparator", "flatten", "Ljava/util/ArrayList;", "Lcom/github/shyiko/ktlint/core/Rule;", "ruleSets", "", "Lcom/github/shyiko/ktlint/core/RuleSet;", "format", "cb", "Lcom/github/shyiko/ktlint/core/LintError;", "", "lint", "findErrorElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visit", "Segment", "SegmentTree", "SuppressionHint", "ktlint-core"})
public final class KtLint {
    private static final PsiFileFactory psiFileFactory;
    private static final Function2<Integer, String, Boolean> nullSuppression;
    public static final KtLint INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void lint(@NotNull String text, @NotNull Iterable<RuleSet> ruleSets, @NotNull Function1<? super LintError, Unit> cb) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(ruleSets, (String)"ruleSets");
        Intrinsics.checkParameterIsNotNull(cb, (String)"cb");
        Function1<Integer, Pair<Integer, Integer>> function1 = this.calculateLineColByOffset(text);
        Function1<Integer, Pair<Integer, Integer>> it = function1;
        Function1<Integer, Integer> offsetDueToLineBreakNormalization = INSTANCE.calculateLineBreakOffset(text);
        Function1 positionByOffset2 = (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(it, offsetDueToLineBreakNormalization){
            final /* synthetic */ Function1 $it;
            final /* synthetic */ Function1 $offsetDueToLineBreakNormalization;

            @NotNull
            public final Pair<Integer, Integer> invoke(int offset) {
                return (Pair)this.$it.invoke((Object)(offset + ((Number)this.$offsetDueToLineBreakNormalization.invoke((Object)offset)).intValue()));
            }
            {
                this.$it = function1;
                this.$offsetDueToLineBreakNormalization = function12;
                super(1);
            }
        };
        String normalizedText = StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)"\r", (String)"\n", (boolean)false, (int)4, null);
        PsiFile psiFile = psiFileFactory.createFileFromText((Language)KotlinLanguage.INSTANCE, (CharSequence)normalizedText);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile psiFile2 = (KtFile)psiFile;
        PsiErrorElement errorElement = this.findErrorElement((PsiElement)psiFile2);
        if (errorElement != null) {
            void col;
            void line;
            Pair pair = (Pair)positionByOffset2.invoke((Object)errorElement.getTextOffset());
            int $i$a$1$let = ((Number)pair.component1()).intValue();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            String string = errorElement.getErrorDescription();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorElement.errorDescription");
            throw (Throwable)new ParseException((int)line, (int)col, string);
        }
        FileASTNode rootNode = psiFile2.getNode();
        ASTNode aSTNode = (ASTNode)rootNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"rootNode");
        Function2<Integer, String, Boolean> isSuppressed = this.calculateSuppressedRegions(aSTNode);
        ArrayList<Pair<String, Rule>> r = this.flatten(ruleSets);
        this.visit((ASTNode)rootNode, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>(r, isSuppressed, positionByOffset2, cb){
            final /* synthetic */ ArrayList $r;
            final /* synthetic */ Function2 $isSuppressed;
            final /* synthetic */ Function1 $positionByOffset;
            final /* synthetic */ Function1 $cb;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Iterable $receiver$iv = this.$r;
                for (T element$iv : $receiver$iv) {
                    void id;
                    Pair it;
                    Pair pair = it = (Pair)element$iv;
                    String string = (String)pair.component1();
                    Rule rule = (Rule)pair.component2();
                    pair = null;
                    if (((Boolean)this.$isSuppressed.invoke((Object)node.getStartOffset(), (Object)id)).booleanValue()) continue;
                    try {
                        void rule2;
                        rule2.visit(node, false, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)((Function3)new Function3<Integer, String, Boolean, Unit>((String)id, this, node){
                            final /* synthetic */ String $id;
                            final /* synthetic */ lint.1 this$0;
                            final /* synthetic */ ASTNode $node$inlined;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(int offset, String errorMessage, boolean canBeAutoCorrected) {
                                void col;
                                void line;
                                Pair pair = (Pair)this.this$0.$positionByOffset.invoke((Object)offset);
                                int n = ((Number)pair.component1()).intValue();
                                int n2 = ((Number)pair.component2()).intValue();
                                pair = null;
                                this.this$0.$cb.invoke((Object)new LintError((int)line, (int)col, this.$id, errorMessage));
                            }
                            {
                                this.$id = string;
                                this.this$0 = var2_2;
                                this.$node$inlined = aSTNode;
                                super(3);
                            }
                        }));
                    }
                    catch (Exception e) {
                        void col;
                        void line;
                        Pair pair2 = (Pair)this.$positionByOffset.invoke((Object)node.getStartOffset());
                        int n = ((Number)pair2.component1()).intValue();
                        int n2 = ((Number)pair2.component2()).intValue();
                        pair2 = null;
                        throw (Throwable)new RuleExecutionException((int)line, (int)col, (String)id, e);
                    }
                }
            }
            {
                this.$r = arrayList;
                this.$isSuppressed = function2;
                this.$positionByOffset = function1;
                this.$cb = function12;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<Pair<String, Rule>> flatten(Iterable<RuleSet> ruleSets) {
        void $receiver$iv;
        ArrayList<Pair<String, Rule>> arrayList = new ArrayList<Pair<String, Rule>>();
        ArrayList<Pair<String, Rule>> $receiver = arrayList;
        Iterable<RuleSet> iterable = ruleSets;
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv2;
            RuleSet ruleSet = (RuleSet)element$iv;
            String prefix = ruleSet.getId() == "standard" ? "" : ruleSet.getId() + ":";
            Iterable iterable2 = ruleSet;
            for (Object element$iv2 : $receiver$iv2) {
                Rule rule = (Rule)element$iv2;
                $receiver.add((Pair<String, Rule>)TuplesKt.to((Object)(prefix + rule.getId()), (Object)rule));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<Integer, Pair<Integer, Integer>> calculateLineColByOffset(String text) {
        void $receiver$iv;
        SegmentTree segmentTree;
        int i = 0;
        int e = text.length();
        ArrayList<Integer> arr = new ArrayList<Integer>();
        do {
            arr.add(i);
        } while ((i = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)i, (boolean)false, (int)4, null) + 1) != 0 && i != e);
        arr.add(e);
        Collection collection = arr;
        SegmentTree segmentTree2 = segmentTree;
        SegmentTree segmentTree3 = segmentTree;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
        if (integerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = integerArray;
        segmentTree2((Integer[])objectArray);
        SegmentTree segmentTree4 = segmentTree3;
        return (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(segmentTree4){
            final /* synthetic */ SegmentTree $segmentTree;

            @NotNull
            public final Pair<Integer, Integer> invoke(int offset) {
                int line = this.$segmentTree.indexOf(offset);
                int col = offset - this.$segmentTree.get(line).getLeft();
                return TuplesKt.to((Object)(line + 1), (Object)(col + 1));
            }
            {
                this.$segmentTree = segmentTree;
                super(1);
            }
        };
    }

    private final Function2<Integer, String, Boolean> calculateSuppressedRegions(ASTNode rootNode) {
        List<SuppressionHint> list = SuppressionHint.Companion.collect(rootNode);
        List<SuppressionHint> it = list;
        return it.isEmpty() ? nullSuppression : (Function2)new Function2<Integer, String, Boolean>(it){
            final /* synthetic */ List $it;

            public final boolean invoke(int offset, @NotNull String ruleId) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)ruleId, (String)"ruleId");
                    Iterable $receiver$iv = this.$it;
                    for (T element$iv : $receiver$iv) {
                        SuppressionHint it = (SuppressionHint)element$iv;
                        if (!((it.getDisabledRules().isEmpty() || it.getDisabledRules().contains(ruleId)) && it.getRange().contains(offset))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$it = list;
                super(2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String format(@NotNull String text, @NotNull Iterable<RuleSet> ruleSets, @NotNull Function2<? super LintError, ? super Boolean, Unit> cb) {
        void autoCorrect;
        void isSuppressed;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(ruleSets, (String)"ruleSets");
        Intrinsics.checkParameterIsNotNull(cb, (String)"cb");
        Function1<Integer, Pair<Integer, Integer>> function1 = this.calculateLineColByOffset(text);
        Function1<Integer, Pair<Integer, Integer>> it = function1;
        Function1<Integer, Integer> offsetDueToLineBreakNormalization = INSTANCE.calculateLineBreakOffset(text);
        Function1 positionByOffset2 = (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(it, offsetDueToLineBreakNormalization){
            final /* synthetic */ Function1 $it;
            final /* synthetic */ Function1 $offsetDueToLineBreakNormalization;

            @NotNull
            public final Pair<Integer, Integer> invoke(int offset) {
                return (Pair)this.$it.invoke((Object)(offset + ((Number)this.$offsetDueToLineBreakNormalization.invoke((Object)offset)).intValue()));
            }
            {
                this.$it = function1;
                this.$offsetDueToLineBreakNormalization = function12;
                super(1);
            }
        };
        String normalizedText = StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)"\r", (String)"\n", (boolean)false, (int)4, null);
        PsiFile psiFile = psiFileFactory.createFileFromText((Language)KotlinLanguage.INSTANCE, (CharSequence)normalizedText);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile psiFile2 = (KtFile)psiFile;
        PsiErrorElement errorElement = this.findErrorElement((PsiElement)psiFile2);
        if (errorElement != null) {
            void col;
            void line;
            Pair pair = (Pair)positionByOffset2.invoke((Object)errorElement.getTextOffset());
            int $i$a$1$let = ((Number)pair.component1()).intValue();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            String string = errorElement.getErrorDescription();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorElement.errorDescription");
            throw (Throwable)new ParseException((int)line, (int)col, string);
        }
        FileASTNode rootNode = psiFile2.getNode();
        Ref.ObjectRef col = new Ref.ObjectRef();
        ASTNode aSTNode = (ASTNode)rootNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"rootNode");
        col.element = this.calculateSuppressedRegions(aSTNode);
        ArrayList<Pair<String, Rule>> r = this.flatten(ruleSets);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        this.visit((ASTNode)rootNode, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>(r, (Ref.ObjectRef)isSuppressed, (Ref.BooleanRef)autoCorrect, positionByOffset2, cb){
            final /* synthetic */ ArrayList $r;
            final /* synthetic */ Ref.ObjectRef $isSuppressed;
            final /* synthetic */ Ref.BooleanRef $autoCorrect;
            final /* synthetic */ Function1 $positionByOffset;
            final /* synthetic */ Function2 $cb;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Iterable $receiver$iv = this.$r;
                for (T element$iv : $receiver$iv) {
                    void id;
                    Pair it;
                    Pair pair = it = (Pair)element$iv;
                    String string = (String)pair.component1();
                    Rule rule = (Rule)pair.component2();
                    pair = null;
                    if (((Boolean)((Function2)this.$isSuppressed.element).invoke((Object)node.getStartOffset(), (Object)id)).booleanValue()) continue;
                    try {
                        void rule2;
                        rule2.visit(node, false, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)((Function3)new Function3<Integer, String, Boolean, Unit>((String)id, this, node){
                            final /* synthetic */ String $id;
                            final /* synthetic */ format.1 this$0;
                            final /* synthetic */ ASTNode $node$inlined;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(int offset, String errorMessage, boolean canBeAutoCorrected) {
                                void col;
                                void line;
                                if (canBeAutoCorrected) {
                                    this.this$0.$autoCorrect.element = true;
                                }
                                Pair pair = (Pair)this.this$0.$positionByOffset.invoke((Object)offset);
                                int n = ((Number)pair.component1()).intValue();
                                int n2 = ((Number)pair.component2()).intValue();
                                pair = null;
                                this.this$0.$cb.invoke((Object)new LintError((int)line, (int)col, this.$id, errorMessage), (Object)canBeAutoCorrected);
                            }
                            {
                                this.$id = string;
                                this.this$0 = var2_2;
                                this.$node$inlined = aSTNode;
                                super(3);
                            }
                        }));
                    }
                    catch (Exception e) {
                        void col;
                        void line;
                        Pair pair2 = (Pair)this.$positionByOffset.invoke((Object)node.getStartOffset());
                        int n = ((Number)pair2.component1()).intValue();
                        int n2 = ((Number)pair2.component2()).intValue();
                        pair2 = null;
                        throw (Throwable)new RuleExecutionException((int)line, (int)col, (String)id, e);
                    }
                }
            }
            {
                this.$r = arrayList;
                this.$isSuppressed = objectRef;
                this.$autoCorrect = booleanRef;
                this.$positionByOffset = function1;
                this.$cb = function2;
                super(1);
            }
        }));
        if (autoCorrect.element) {
            this.visit((ASTNode)rootNode, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>(r, (Ref.ObjectRef)isSuppressed, rootNode){
                final /* synthetic */ ArrayList $r;
                final /* synthetic */ Ref.ObjectRef $isSuppressed;
                final /* synthetic */ FileASTNode $rootNode;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    Iterable $receiver$iv = this.$r;
                    for (T element$iv : $receiver$iv) {
                        void id;
                        Pair it;
                        Pair pair = it = (Pair)element$iv;
                        String string = (String)pair.component1();
                        Rule rule = (Rule)pair.component2();
                        pair = null;
                        if (((Boolean)((Function2)this.$isSuppressed.element).invoke((Object)node.getStartOffset(), (Object)id)).booleanValue()) continue;
                        try {
                            void rule2;
                            rule2.visit(node, true, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)((Function3)new Function3<Integer, String, Boolean, Unit>(this, node){
                                final /* synthetic */ format.2 this$0;
                                final /* synthetic */ ASTNode $node$inlined;

                                public final void invoke(int offset, String errorMessage, boolean canBeAutoCorrected) {
                                    if (canBeAutoCorrected && (Function2)this.this$0.$isSuppressed.element != KtLint.access$getNullSuppression$p(KtLint.INSTANCE)) {
                                        Ref.ObjectRef objectRef = this.this$0.$isSuppressed;
                                        ASTNode aSTNode = (ASTNode)this.this$0.$rootNode;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"rootNode");
                                        objectRef.element = KtLint.access$calculateSuppressedRegions(KtLint.INSTANCE, aSTNode);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$node$inlined = aSTNode;
                                    super(3);
                                }
                            }));
                        }
                        catch (Exception e) {
                            throw (Throwable)new RuleExecutionException(0, 0, (String)id, e);
                        }
                    }
                }
                {
                    this.$r = arrayList;
                    this.$isSuppressed = objectRef;
                    this.$rootNode = fileASTNode;
                    super(1);
                }
            }));
            return StringsKt.replace$default((String)rootNode.getText(), (String)"\n", (String)this.determineLineSeparator(text), (boolean)false, (int)4, null);
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<Integer, Integer> calculateLineBreakOffset(String fileContent) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int i = 0;
        do {
            arr.add(i);
        } while ((i = StringsKt.indexOf$default((CharSequence)fileContent, (String)"\r\n", (int)(i + 1), (boolean)false, (int)4, null)) != -1);
        arr.add(fileContent.length());
        if (arr.size() != 2) {
            void $receiver$iv;
            SegmentTree segmentTree;
            Object object = arr;
            SegmentTree segmentTree2 = segmentTree;
            SegmentTree segmentTree3 = segmentTree;
            Collection thisCollection$iv = (Collection)$receiver$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
            if (integerArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = integerArray;
            segmentTree2((Integer[])objectArray);
            object = segmentTree3;
            SegmentTree it = (SegmentTree)object;
            return (Function1)new Function1<Integer, Integer>(it){
                final /* synthetic */ SegmentTree $it;

                public final int invoke(int offset) {
                    return this.$it.indexOf(offset);
                }
                {
                    this.$it = segmentTree;
                    super(1);
                }
            };
        }
        return calculateLineBreakOffset.2.INSTANCE;
    }

    private final String determineLineSeparator(String fileContent) {
        int i = StringsKt.lastIndexOf$default((CharSequence)fileContent, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            String string;
            if (StringsKt.lastIndexOf$default((CharSequence)fileContent, (char)'\r', (int)0, (boolean)false, (int)6, null) == -1) {
                String string2 = System.getProperty("line.separator");
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"line.separator\")");
            } else {
                string = "\r";
            }
            return string;
        }
        return i != 0 && fileContent.charAt(i) == '\r' ? "\r\n" : "\n";
    }

    private final PsiErrorElement findErrorElement(@NotNull PsiElement $receiver) {
        if ($receiver instanceof PsiErrorElement) {
            return (PsiErrorElement)$receiver;
        }
        Object[] $receiver$iv = $receiver.getChildren();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            PsiElement it = (PsiElement)element$iv;
            PsiErrorElement errorElement = INSTANCE.findErrorElement(it);
            if (errorElement == null) continue;
            return errorElement;
        }
        return null;
    }

    private final void visit(@NotNull ASTNode $receiver, Function1<? super ASTNode, Unit> cb) {
        cb.invoke((Object)$receiver);
        Object[] $receiver$iv = $receiver.getChildren((TokenSet)null);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ASTNode it = (ASTNode)element$iv;
            INSTANCE.visit(it, cb);
        }
    }

    /*
     * WARNING - void declaration
     */
    private KtLint() {
        void elements$iv;
        INSTANCE = this;
        nullSuppression = nullSuppression.1.INSTANCE;
        Project project2 = KotlinCoreEnvironment.Companion.createForProduction((Disposable)project.1.INSTANCE, new CompilerConfiguration(), CollectionsKt.emptyList()).getProject();
        PomModel pomModel2 = new PomModel(){

            public void runTransaction(@NotNull PomTransaction transaction) {
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                PomTransaction pomTransaction = transaction;
                if (pomTransaction == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase");
                }
                ((PomTransactionBase)pomTransaction).run();
            }

            @Nullable
            public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aspect) {
                Intrinsics.checkParameterIsNotNull(aspect, (String)"aspect");
                if (Intrinsics.areEqual(aspect, TreeAspect.class)) {
                    Constructor<?> constructor;
                    Class[] classArray = new Class[]{};
                    Constructor<?> constructor2 = constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(aspect, Object.class.getDeclaredConstructor(Arrays.copyOf(classArray, classArray.length)));
                    Object[] objectArray = new Object[]{};
                    ? obj = constructor2.newInstance(Arrays.copyOf(objectArray, objectArray.length));
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)((PomModelAspect)obj);
                }
                return (T)((PomModelAspect)null);
            }

            public void addModelListener(@NotNull PomModelListener listener) {
                Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            }
        };
        String extensionPoint = "org.jetbrains.kotlin.com.intellij.treeCopyHandler";
        String string = TreeCopyHandler.class.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String extensionClassName = string;
        ExtensionsArea[] extensionsAreaArray = new ExtensionsArea[]{Extensions.getArea((AreaInstance)((AreaInstance)project2)), Extensions.getArea((AreaInstance)null)};
        ExtensionsArea[] extensionsAreaArray2 = (ExtensionsArea[])((Object[])elements$iv);
        for (int i = 0; i < extensionsAreaArray2.length; ++i) {
            ExtensionsArea area = extensionsAreaArray2[i];
            if (area.hasExtensionPoint(extensionPoint)) continue;
            area.registerExtensionPoint(extensionPoint, extensionClassName, ExtensionPoint.Kind.INTERFACE);
        }
        Project project3 = project2;
        if (project3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.mock.MockProject");
        }
        ((MockProject)project3).registerService(PomModel.class, (Object)pomModel2);
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileFactory, (String)"PsiFileFactory.getInstance(project)");
        KtLint.psiFileFactory = psiFileFactory;
    }

    static {
        new KtLint();
    }

    @NotNull
    public static final /* synthetic */ Function2 access$getNullSuppression$p(KtLint $this) {
        KtLint ktLint = $this;
        return nullSuppression;
    }

    @NotNull
    public static final /* synthetic */ Function2 access$calculateSuppressedRegions(KtLint $this, @NotNull ASTNode rootNode) {
        return $this.calculateSuppressedRegions(rootNode);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/github/shyiko/ktlint/core/KtLint$SuppressionHint;", "", "range", "Lkotlin/ranges/IntRange;", "disabledRules", "", "", "(Lkotlin/ranges/IntRange;Ljava/util/Set;)V", "getDisabledRules", "()Ljava/util/Set;", "getRange", "()Lkotlin/ranges/IntRange;", "component1", "component2", "copy", "Companion", "ktlint-core"})
    private static final class SuppressionHint {
        @NotNull
        private final IntRange range;
        @NotNull
        private final Set<String> disabledRules;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        @NotNull
        public final Set<String> getDisabledRules() {
            return this.disabledRules;
        }

        public SuppressionHint(@NotNull IntRange range, @NotNull Set<String> disabledRules) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull(disabledRules, (String)"disabledRules");
            this.range = range;
            this.disabledRules = disabledRules;
        }

        public /* synthetic */ SuppressionHint(IntRange intRange, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            this(intRange, set);
        }

        @NotNull
        public final IntRange component1() {
            return this.range;
        }

        @NotNull
        public final Set<String> component2() {
            return this.disabledRules;
        }

        @NotNull
        public final SuppressionHint copy(@NotNull IntRange range, @NotNull Set<String> disabledRules) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull(disabledRules, (String)"disabledRules");
            return new SuppressionHint(range, disabledRules);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SuppressionHint copy$default(SuppressionHint suppressionHint, IntRange intRange, Set set, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                intRange = suppressionHint.range;
            }
            if ((n & 2) != 0) {
                set = suppressionHint.disabledRules;
            }
            return suppressionHint.copy(intRange, set);
        }

        public String toString() {
            return "SuppressionHint(range=" + this.range + ", disabledRules=" + this.disabledRules + ")";
        }

        public int hashCode() {
            IntRange intRange = this.range;
            Set<String> set = this.disabledRules;
            return (intRange != null ? intRange.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SuppressionHint)) break block3;
                    SuppressionHint suppressionHint = (SuppressionHint)object;
                    if (!Intrinsics.areEqual((Object)this.range, (Object)suppressionHint.range) || !Intrinsics.areEqual(this.disabledRules, suppressionHint.disabledRules)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/github/shyiko/ktlint/core/KtLint$SuppressionHint$Companion;", "", "()V", "collect", "", "Lcom/github/shyiko/ktlint/core/KtLint$SuppressionHint;", "rootNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "parseHintArgs", "", "commentText", "key", "splitCommentBySpace", "comment", "tail", "T", "ktlint-core"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<SuppressionHint> collect(@NotNull ASTNode rootNode) {
                List list;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)rootNode, (String)"rootNode");
                ArrayList result = new ArrayList();
                ArrayList open = new ArrayList();
                INSTANCE.visit(rootNode, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>(result, open){
                    final /* synthetic */ ArrayList $result;
                    final /* synthetic */ ArrayList $open;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ASTNode node) {
                        block12: {
                            List $receiver;
                            List list;
                            String commentText;
                            Object object;
                            block14: {
                                String text;
                                block13: {
                                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                                    if (!(node instanceof PsiComment)) break block12;
                                    text = node.getText();
                                    if (!StringsKt.startsWith$default((String)text, (String)"//", (boolean)false, (int)2, null)) break block13;
                                    Object object2 = StringsKt.removePrefix((String)text, (CharSequence)"//");
                                    String string = object2;
                                    if (string == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    String commentText2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                                    List list2 = com.github.shyiko.ktlint.core.KtLint$SuppressionHint$Companion.access$parseHintArgs(SuppressionHint.Companion, commentText2, "ktlint-disable");
                                    if (list2 != null) {
                                        int n;
                                        object2 = list2;
                                        List args = (List)object2;
                                        PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)PsiUtilsKt.prevLeaf((PsiElement)((PsiElement)node), (Function1)collect.1.lineStart.1.INSTANCE);
                                        if (psiWhiteSpace != null) {
                                            PsiWhiteSpace psiWhiteSpace2 = psiWhiteSpace;
                                            PsiWhiteSpace it = psiWhiteSpace2;
                                            n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)) + StringsKt.lastIndexOf$default((CharSequence)it.getText(), (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
                                        } else {
                                            n = 0;
                                        }
                                        int lineStart2 = n;
                                        this.$result.add(new SuppressionHint(new IntRange(lineStart2, node.getStartOffset()), (Set<String>)new HashSet<E>(args)));
                                    }
                                    break block12;
                                }
                                object = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"/*"), (CharSequence)"*/");
                                String string = object;
                                if (string == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                commentText = ((Object)StringsKt.trim((CharSequence)string)).toString();
                                list = com.github.shyiko.ktlint.core.KtLint$SuppressionHint$Companion.access$parseHintArgs(SuppressionHint.Companion, commentText, "ktlint-disable");
                                if (list == null) break block14;
                                object = list;
                                $receiver = (List)object;
                                this.$open.add(new SuppressionHint(new IntRange(node.getStartOffset(), node.getStartOffset()), (Set<String>)new HashSet<E>($receiver)));
                                list = (List)object;
                                if (list != null) break block12;
                            }
                            List list3 = com.github.shyiko.ktlint.core.KtLint$SuppressionHint$Companion.access$parseHintArgs(SuppressionHint.Companion, commentText, "ktlint-enable");
                            if (list3 != null) {
                                int openHintIndex;
                                HashSet<E> disabledRules;
                                block11: {
                                    int n;
                                    void $receiver$iv;
                                    object = list3;
                                    $receiver = (List)object;
                                    disabledRules = new HashSet<E>($receiver);
                                    List it = this.$open;
                                    ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                                    while (iterator$iv.hasPrevious()) {
                                        SuppressionHint it2 = (SuppressionHint)iterator$iv.previous();
                                        if (!Intrinsics.areEqual(it2.getDisabledRules(), disabledRules)) continue;
                                        n = iterator$iv.nextIndex();
                                        break block11;
                                    }
                                    n = openHintIndex = -1;
                                }
                                if (openHintIndex != -1) {
                                    SuppressionHint openingHint = (SuppressionHint)this.$open.remove(openHintIndex);
                                    this.$result.add(new SuppressionHint(new IntRange(((Number)openingHint.getRange().getStart()).intValue(), node.getStartOffset()), (Set<String>)disabledRules));
                                }
                                list = (List)object;
                            } else {
                                list = null;
                            }
                        }
                    }
                    {
                        this.$result = arrayList;
                        this.$open = arrayList2;
                        super(1);
                    }
                }));
                Iterable iterable = open;
                ArrayList arrayList = result;
                void var5_6 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    SuppressionHint suppressionHint = (SuppressionHint)item$iv$iv;
                    list = destination$iv$iv;
                    SuppressionHint suppressionHint2 = new SuppressionHint(new IntRange(it.getRange().getFirst(), rootNode.getTextLength()), it.getDisabledRules());
                    list.add(suppressionHint2);
                }
                list = (List)destination$iv$iv;
                arrayList.addAll(list);
                return result;
            }

            private final List<String> parseHintArgs(String commentText, String key) {
                List<String> parsedComment;
                if (StringsKt.startsWith$default((String)commentText, (String)key, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(parsedComment = this.splitCommentBySpace(commentText)).get(0), (Object)key)) {
                    return this.tail(parsedComment);
                }
                return null;
            }

            private final List<String> splitCommentBySpace(String comment) {
                CharSequence charSequence = comment;
                Regex regex = new Regex("\\s");
                String string = " ";
                return StringsKt.split$default((CharSequence)StringsKt.replace$default((String)regex.replace(charSequence, string), (String)" {2,}", (String)" ", (boolean)false, (int)4, null), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
            }

            private final <T> List<T> tail(@NotNull List<? extends T> $receiver) {
                return $receiver.subList(1, $receiver.size());
            }

            private Companion() {
            }

            @Nullable
            public static final /* synthetic */ List access$parseHintArgs(Companion $this, @NotNull String commentText, @NotNull String key) {
                return $this.parseHintArgs(commentText, key);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/shyiko/ktlint/core/KtLint$SegmentTree;", "", "sortedArray", "", "", "([Ljava/lang/Integer;)V", "segments", "", "Lcom/github/shyiko/ktlint/core/KtLint$Segment;", "binarySearch", "v", "l", "r", "get", "i", "indexOf", "ktlint-core"})
    private static final class SegmentTree {
        private final List<Segment> segments;

        @NotNull
        public final Segment get(int i) {
            return this.segments.get(i);
        }

        public final int indexOf(int v) {
            return this.binarySearch(v, 0, this.segments.size() - 1);
        }

        private final int binarySearch(int v, int l, int r) {
            int i;
            Segment s;
            return l > r ? -1 : (v < (s = this.segments.get(i = l + (r - l) / 2)).getLeft() ? this.binarySearch(v, l, i - 1) : (s.getRight() < v ? this.binarySearch(v, i + 1, r) : i));
        }

        /*
         * WARNING - void declaration
         */
        public SegmentTree(@NotNull Integer[] sortedArray) {
            List list;
            void destination$iv$iv;
            void $receiver$iv$iv;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)sortedArray, (String)"sortedArray");
            boolean bl = ((Object[])sortedArray).length > 1;
            if (!bl) {
                String string = "At least two data points are required";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object $receiver$iv = sortedArray;
            Object[] $i$a$1$require = $receiver$iv;
            if ($i$a$1$require.length == 0) {
                throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
            }
            Object accumulator$iv = $receiver$iv[0];
            int n2 = 1;
            int n3 = ArraysKt.getLastIndex((Object[])$receiver$iv);
            if (n2 <= n3) {
                while (true) {
                    void v;
                    void index$iv;
                    int n4 = ((Number)$receiver$iv[index$iv]).intValue();
                    int r = ((Number)accumulator$iv).intValue();
                    n = r <= v ? 1 : 0;
                    if (n == 0) {
                        String string = "Data points are not sorted (ASC)";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    accumulator$iv = (int)v;
                    if (index$iv == n3) break;
                    ++index$iv;
                }
            }
            $receiver$iv = ArraysKt.take((Object[])sortedArray, (int)(((Object[])sortedArray).length - 1));
            SegmentTree segmentTree = this;
            accumulator$iv = $receiver$iv;
            Collection index$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void i;
                void v;
                int n5 = index$iv$iv++;
                n = ((Number)item$iv$iv).intValue();
                int n6 = n5;
                list = destination$iv$iv;
                Segment segment = new Segment((int)v, sortedArray[i + true] - 1);
                list.add(segment);
            }
            segmentTree.segments = list = (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/github/shyiko/ktlint/core/KtLint$Segment;", "", "left", "", "right", "(II)V", "getLeft", "()I", "getRight", "component1", "component2", "copy", "ktlint-core"})
    private static final class Segment {
        private final int left;
        private final int right;

        public final int getLeft() {
            return this.left;
        }

        public final int getRight() {
            return this.right;
        }

        public Segment(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public final int component1() {
            return this.left;
        }

        public final int component2() {
            return this.right;
        }

        @NotNull
        public final Segment copy(int left, int right) {
            return new Segment(left, right);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Segment copy$default(Segment segment, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n3 & 1) != 0) {
                n = segment.left;
            }
            if ((n3 & 2) != 0) {
                n2 = segment.right;
            }
            return segment.copy(n, n2);
        }

        public String toString() {
            return "Segment(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            return this.left * 31 + this.right;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Segment)) break block3;
                    Segment segment = (Segment)object;
                    if (!(this.left == segment.left) || !(this.right == segment.right)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

