/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j_javascript;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoCompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(String script) {
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        try {
            ScriptableObject scope = cx.initStandardObjects();
            Object obj = cx.evaluateString((Scriptable)scope, script, "Embedded Script", 1, null);
            Result result = new Result(obj, null);
            return result;
        }
        catch (RhinoException ex) {
            System.err.println(ex.getMessage());
            System.err.println(script);
            Result result = new Result(null, ex.getMessage());
            return result;
        }
        finally {
            Context.exit();
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        RhinoCompiler me = new RhinoCompiler();
        System.out.println(me.execute("'hey'.trim()").getResult());
        String test = IOUtils.toString((Reader)new FileReader(new File("src\\test\\resources\\test.js")));
        System.out.println(me.execute(test).getResult());
    }

    public static class Result {
        private final Object result;
        private final String error;

        public Result(Object result, String error) {
            this.result = result;
            this.error = error;
        }

        public Object getResult() {
            return this.result;
        }

        public String getError() {
            return this.error;
        }

        public boolean hasError() {
            return this.error != null;
        }
    }
}

