/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.PropertyType;
import org.sonar.api.Startable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.findbugs.FindbugsPlugin;
import org.sonar.plugins.findbugs.xml.Bug;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;
import org.sonar.plugins.findbugs.xml.Match;
import org.sonar.plugins.java.api.JavaResourceLocator;
import shaded.io.FileUtils;
import shaded.io.IOUtils;

@ScannerSide
public class FindbugsConfiguration
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(FindbugsConfiguration.class);
    private final FileSystem fileSystem;
    private final Configuration config;
    private final ActiveRules activeRules;
    private final JavaResourceLocator javaResourceLocator;
    private File jsr305Lib;
    private File annotationsLib;
    private File fbContrib;
    private File findSecBugs;

    public FindbugsConfiguration(FileSystem fileSystem, Configuration config, ActiveRules activeRules, JavaResourceLocator javaResourceLocator) {
        this.fileSystem = fileSystem;
        this.config = config;
        this.activeRules = activeRules;
        this.javaResourceLocator = javaResourceLocator;
    }

    public File getTargetXMLReport() {
        return new File(this.fileSystem.workDir(), "findbugs-result.xml");
    }

    public Project getFindbugsProject() throws IOException {
        Project findbugsProject = new Project();
        ArrayList<File> classFilesToAnalyze = new ArrayList<File>(this.javaResourceLocator.classFilesToAnalyze());
        for (File file : this.javaResourceLocator.classpath()) {
            if (file.isDirectory()) {
                classFilesToAnalyze.addAll(FindbugsConfiguration.scanForAdditionalClasses(file));
            }
            findbugsProject.addAuxClasspathEntry(file.getCanonicalPath());
        }
        boolean hasJspFiles = this.fileSystem.hasFiles(this.fileSystem.predicates().hasLanguage("jsp"));
        boolean hasPrecompiledJsp = false;
        for (File classToAnalyze : classFilesToAnalyze) {
            String absolutePath = classToAnalyze.getCanonicalPath();
            if (hasJspFiles && !hasPrecompiledJsp && (absolutePath.endsWith("_jsp.class") || absolutePath.contains("/jsp_servlet/"))) {
                hasPrecompiledJsp = true;
            }
            if ("module-info.class".equals(classToAnalyze.getName())) continue;
            findbugsProject.addFile(absolutePath);
        }
        if (classFilesToAnalyze.isEmpty()) {
            LOG.warn("Findbugs needs sources to be compiled. Please build project before executing sonar or check the location of compiled classes to make it possible for Findbugs to analyse your (sub)project ({}).", (Object)this.fileSystem.baseDir().getPath());
            if (!this.isAllowUncompiledCode() && this.hasSourceFiles()) {
                throw new IllegalStateException(String.format("One (sub)project contains Java source files that are not compiled (%s).", this.fileSystem.baseDir().getPath()));
            }
        }
        if (hasJspFiles && !hasPrecompiledJsp) {
            LOG.warn("JSP files were found in the current (sub)project ({}) but FindBugs requires their precompiled form. For more information on how to configure JSP precompilation : https://github.com/find-sec-bugs/find-sec-bugs/wiki/JSP-precompilation", (Object)this.fileSystem.baseDir().getPath());
        }
        this.copyLibs();
        if (this.annotationsLib != null) {
            findbugsProject.addAuxClasspathEntry(this.annotationsLib.getCanonicalPath());
            findbugsProject.addAuxClasspathEntry(this.jsr305Lib.getCanonicalPath());
        }
        findbugsProject.setCurrentWorkingDirectory(this.fileSystem.workDir());
        return findbugsProject;
    }

    private void exportProfile(ActiveRules activeRules, Writer writer) {
        try {
            FindBugsFilter filter = FindbugsConfiguration.buildFindbugsFilter(activeRules.findAll().stream().filter(activeRule -> {
                String repKey = activeRule.ruleKey().repository();
                return repKey.contains("findbugs") || repKey.contains("findsecbugs") || repKey.contains("fb-contrib");
            }).collect(Collectors.toList()));
            XStream xstream = FindBugsFilter.createXStream();
            writer.append(xstream.toXML((Object)filter));
        }
        catch (IOException e) {
            throw new SonarException("Fail to generate the Findbugs profile configuration", (Throwable)e);
        }
    }

    private static FindBugsFilter buildFindbugsFilter(Iterable<ActiveRule> activeRules) {
        FindBugsFilter root = new FindBugsFilter();
        for (ActiveRule activeRule : activeRules) {
            String repoKey = activeRule.ruleKey().repository();
            if (!repoKey.contains("findsecbugs") && !repoKey.contains("findbugs") && !repoKey.contains("fb-contrib")) continue;
            Match child = new Match();
            child.setBug(new Bug(activeRule.internalKey()));
            root.addMatch(child);
        }
        return root;
    }

    private boolean hasSourceFiles() {
        FilePredicates pred = this.fileSystem.predicates();
        return this.fileSystem.hasFiles(pred.and(new FilePredicate[]{pred.hasType(InputFile.Type.MAIN), pred.or(FindbugsPlugin.getSupportedLanguagesFilePredicate(pred)), pred.not(pred.matchesPathPattern("**/package-info.java")), pred.not(pred.matchesPathPattern("**/module-info.java")), pred.not(pred.matchesPathPattern("**/*.jsp"))}));
    }

    @VisibleForTesting
    File saveIncludeConfigXml() throws IOException {
        StringWriter conf = new StringWriter();
        this.exportProfile(this.activeRules, conf);
        File file = new File(this.fileSystem.workDir(), "findbugs-include.xml");
        FileUtils.write(file, (CharSequence)conf.toString(), "UTF-8");
        return file;
    }

    public static List<File> scanForAdditionalClasses(File folder) {
        File dirPoll;
        ArrayList<File> allFiles = new ArrayList<File>();
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(folder);
        while (!dirs.isEmpty() && (dirPoll = (File)dirs.poll()) != null) {
            for (File f : dirPoll.listFiles()) {
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                allFiles.add(f);
            }
        }
        return allFiles;
    }

    @VisibleForTesting
    List<File> getExcludesFilters() {
        String[] filters;
        ArrayList result = Lists.newArrayList();
        PathResolver pathResolver = new PathResolver();
        for (String excludesFilterPath : filters = this.config.getStringArray("sonar.findbugs.excludesFilters")) {
            if (!StringUtils.isNotBlank((String)(excludesFilterPath = StringUtils.trim((String)excludesFilterPath)))) continue;
            result.add(pathResolver.relativeFile(this.fileSystem.baseDir(), excludesFilterPath));
        }
        return result;
    }

    public String getEffort() {
        return StringUtils.lowerCase((String)this.config.get("sonar.findbugs.effort").orElse("Default"));
    }

    public String getConfidenceLevel() {
        return StringUtils.lowerCase((String)this.config.get("sonar.findbugs.confidenceLevel").orElse("medium"));
    }

    public long getTimeout() {
        return this.config.getLong("sonar.findbugs.timeout").orElse(600000L);
    }

    public boolean isAllowUncompiledCode() {
        return this.config.getBoolean("sonar.findbugs.allowuncompiledcode").orElse(false);
    }

    public void copyLibs() {
        if (this.jsr305Lib == null) {
            this.jsr305Lib = this.copyLib("/jsr305.jar");
        }
        if (this.annotationsLib == null) {
            this.annotationsLib = this.copyLib("/annotations.jar");
        }
        if (this.fbContrib == null) {
            this.fbContrib = this.copyLib("/sb-contrib.jar");
        }
        if (this.findSecBugs == null) {
            this.findSecBugs = this.copyLib("/findsecbugs-plugin.jar");
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.jsr305Lib != null) {
            this.jsr305Lib.delete();
        }
        if (this.annotationsLib != null) {
            this.annotationsLib.delete();
        }
        if (this.fbContrib != null) {
            this.fbContrib.delete();
        }
        if (this.findSecBugs != null) {
            this.findSecBugs.delete();
        }
    }

    private File copyLib(String name) {
        File file;
        InputStream input = null;
        try {
            input = this.getClass().getResourceAsStream(name);
            File dir = new File(this.fileSystem.workDir(), "findbugs");
            FileUtils.forceMkdir(dir);
            File target = new File(dir, name);
            FileUtils.copyInputStreamToFile(input, target);
            file = target;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Fail to extract Findbugs dependency", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        return file;
    }

    public File getFbContribJar() {
        return this.fbContrib;
    }

    public File getFindSecBugsJar() {
        return this.findSecBugs;
    }

    public static List<PropertyDefinition> getPropertyDefinitions() {
        String subCategory = "FindBugs";
        return ImmutableList.of((Object)PropertyDefinition.builder((String)"sonar.findbugs.effort").defaultValue("Default").category("java").subCategory(subCategory).name("Effort").description("Effort of the bug finders. Valid values are Min, Default and Max. Setting 'Max' increases precision but also increases memory consumption.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)"sonar.findbugs.timeout").defaultValue(Long.toString(600000L)).category("java").subCategory(subCategory).name("Timeout").description("Specifies the amount of time, in milliseconds, that FindBugs may run before it is assumed to be hung and is terminated. The default is 600,000 milliseconds, which is ten minutes.").onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.INTEGER).build(), (Object)PropertyDefinition.builder((String)"sonar.findbugs.excludesFilters").category("java").subCategory(subCategory).name("Excludes Filters").description("Paths to findbugs filter-files with exclusions.").onQualifiers("TRK", new String[]{"BRC"}).multiValues(true).build(), (Object)PropertyDefinition.builder((String)"sonar.findbugs.confidenceLevel").defaultValue("medium").category("java").subCategory(subCategory).name("Confidence Level").description("Specifies the confidence threshold (previously called \"priority\") for reporting issues. If set to \"low\", confidence is not used to filter bugs. If set to \"medium\" (the default), low confidence issues are suppressed. If set to \"high\", only high confidence bugs are reported. ").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)"sonar.findbugs.allowuncompiledcode").defaultValue(Boolean.toString(false)).type(PropertyType.BOOLEAN).category("java").subCategory(subCategory).name("Allow Uncompiled Code").description("Remove the compiled code requirement for all projects. It can lead to a false sense of security if the build process skips certain projects.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)"sonar.findbugs.reportpaths").category("java").subCategory(subCategory).name("Report Paths").description("Relative path to SpotBugs report files intended to be reused. (<code>/target/findbugsXml.xml</code> and <code>/target/spotbugsXml.xml</code> are included by default)").onQualifiers("TRK", new String[]{"BRC"}).multiValues(true).build());
    }
}

