/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.XMLBugReporter;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;
import org.sonar.plugins.findbugs.FindbugsConfiguration;
import org.sonar.plugins.findbugs.ReportedBug;
import shaded.io.FileUtils;
import shaded.io.IOUtils;

@ScannerSide
public class FindbugsExecutor {
    private static final String FINDBUGS_CORE_PLUGIN_ID = "edu.umd.cs.findbugs.plugins.core";
    private static final Logger LOG = LoggerFactory.getLogger(FindbugsExecutor.class);
    public static final List<String> EXISTING_FINDBUGS_REPORT_PATHS = Arrays.asList("/target/findbugsXml.xml", "/target/spotbugsXml.xml");
    private FileSystem fs;
    private Configuration config;
    private static Map<String, Integer> priorityNameToValueMap = new HashMap<String, Integer>();
    private static final Integer DEFAULT_PRIORITY;
    private final FindbugsConfiguration configuration;

    public FindbugsExecutor(FindbugsConfiguration configuration, FileSystem fs, Configuration config) {
        this.configuration = configuration;
        this.fs = fs;
        this.config = config;
    }

    @VisibleForTesting
    Collection<ReportedBug> execute() {
        return this.execute(true);
    }

    public Collection<ReportedBug> execute(boolean useAllPlugin) {
        return this.execute(useAllPlugin, useAllPlugin);
    }

    public Collection<ReportedBug> execute(boolean useFbContrib, boolean useFindSecBugs) {
        Collection<ReportedBug> collection;
        SecurityManager currentSecurityManager = System.getSecurityManager();
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(FindBugs2.class.getClassLoader());
        Locale initialLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        FileOutputStream xmlOutput = null;
        Collection<Plugin> customPlugins = null;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            FindBugs2 engine = new FindBugs2();
            Project project = this.configuration.getFindbugsProject();
            if (project.getFileCount() == 0) {
                LOG.info("Findbugs analysis skipped for this project.");
                ArrayList<ReportedBug> arrayList = new ArrayList<ReportedBug>();
                return arrayList;
            }
            customPlugins = this.loadFindbugsPlugins(useFbContrib, useFindSecBugs);
            FindbugsExecutor.disableUpdateChecksOnEveryPlugin();
            engine.setProject(project);
            XMLBugReporter xmlBugReporter = new XMLBugReporter(project);
            xmlBugReporter.setPriorityThreshold(this.determinePriorityThreshold().intValue());
            xmlBugReporter.setAddMessages(true);
            File xmlReport = this.configuration.getTargetXMLReport();
            LOG.info("Findbugs output report: " + xmlReport.getAbsolutePath());
            xmlOutput = FileUtils.openOutputStream(xmlReport);
            xmlBugReporter.setOutputStream(new PrintStream(xmlOutput));
            engine.setBugReporter((BugReporter)xmlBugReporter);
            UserPreferences userPreferences = UserPreferences.createDefaultUserPreferences();
            userPreferences.setEffort(this.configuration.getEffort());
            engine.setUserPreferences(userPreferences);
            engine.addFilter(this.configuration.saveIncludeConfigXml().getAbsolutePath(), true);
            for (File filterFile : this.configuration.getExcludesFilters()) {
                if (filterFile.isFile()) {
                    LOG.info("Use filter-file: {}", (Object)filterFile);
                    engine.addFilter(filterFile.getAbsolutePath(), false);
                    continue;
                }
                LOG.warn("FindBugs filter-file not found: {}", (Object)filterFile);
            }
            engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
            engine.setAnalysisFeatureSettings(FindBugs.DEFAULT_EFFORT);
            engine.finishSettings();
            ArrayList<String> potentialReportPaths = new ArrayList<String>();
            potentialReportPaths.addAll(EXISTING_FINDBUGS_REPORT_PATHS);
            String[] paths = this.config.getStringArray("sonar.findbugs.reportpaths");
            if (paths != null) {
                potentialReportPaths.addAll(Arrays.asList(paths));
            }
            boolean foundExistingReport = false;
            for (String potentialPath : potentialReportPaths) {
                File findbugsReport = new File(this.fs.baseDir(), potentialPath);
                if (!findbugsReport.exists() || findbugsReport.length() <= 0L) continue;
                LOG.info("FindBugs report is already generated {}. Reusing the report.", (Object)findbugsReport.getAbsolutePath());
                xmlBugReporter.getBugCollection().readXML((Reader)new FileReader(findbugsReport));
                foundExistingReport = true;
                break;
            }
            if (!foundExistingReport) {
                executorService.submit(new FindbugsTask(engine)).get(this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
            }
            collection = FindbugsExecutor.toReportedBugs(xmlBugReporter.getBugCollection());
            System.setSecurityManager(currentSecurityManager);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Can not execute Findbugs with a timeout threshold value of " + this.configuration.getTimeout() + " milliseconds", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not execute Findbugs", e);
        }
        finally {
            System.setSecurityManager(currentSecurityManager);
            FindbugsExecutor.resetCustomPluginList(customPlugins);
            executorService.shutdown();
            IOUtils.closeQuietly(xmlOutput);
            Thread.currentThread().setContextClassLoader(initialClassLoader);
            Locale.setDefault(initialLocale);
        }
        FindbugsExecutor.resetCustomPluginList(customPlugins);
        executorService.shutdown();
        IOUtils.closeQuietly(xmlOutput);
        Thread.currentThread().setContextClassLoader(initialClassLoader);
        Locale.setDefault(initialLocale);
        return collection;
    }

    private static Collection<ReportedBug> toReportedBugs(BugCollection bugCollection) {
        ArrayList<ReportedBug> bugs = new ArrayList<ReportedBug>();
        for (BugInstance bugInstance : bugCollection) {
            if (bugInstance.getPrimarySourceLineAnnotation() == null) {
                LOG.warn("No source line for " + bugInstance.getType());
                continue;
            }
            bugs.add(new ReportedBug(bugInstance));
        }
        return bugs;
    }

    private Integer determinePriorityThreshold() {
        Integer integer = priorityNameToValueMap.get(this.configuration.getConfidenceLevel());
        if (integer == null) {
            integer = DEFAULT_PRIORITY;
        }
        return integer;
    }

    private Collection<Plugin> loadFindbugsPlugins(boolean useFbContrib, boolean useFindSecBugs) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList pluginJarPathList = Lists.newArrayList();
        try {
            Enumeration<URL> urls = contextClassLoader.getResources("findbugs.xml");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                pluginJarPathList.add(FindbugsExecutor.normalizeUrl(url));
            }
            if (useFbContrib && this.configuration.getFbContribJar() != null) {
                pluginJarPathList.add(this.configuration.getFbContribJar().getAbsolutePath());
            }
            if (useFindSecBugs && this.configuration.getFindSecBugsJar() != null) {
                pluginJarPathList.add(this.configuration.getFindSecBugsJar().getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        ArrayList customPluginList = Lists.newArrayList();
        for (String path : pluginJarPathList) {
            try {
                Plugin plugin = Plugin.addCustomPlugin((URI)new File(path).toURI(), (ClassLoader)contextClassLoader);
                if (plugin == null) continue;
                customPluginList.add(plugin);
                LOG.info("Loading findbugs plugin: " + path);
            }
            catch (PluginException e) {
                LOG.warn("Failed to load plugin for custom detector: " + path);
                LOG.debug("Cause of failure", (Throwable)e);
            }
            catch (DuplicatePluginIdException e) {
                if (FINDBUGS_CORE_PLUGIN_ID.equals(e.getPluginId())) continue;
                LOG.debug("Plugin already loaded: exception ignored: " + e.getMessage(), (Throwable)e);
            }
        }
        return customPluginList;
    }

    private static String normalizeUrl(URL url) throws URISyntaxException {
        return StringUtils.removeStart((String)StringUtils.substringBefore((String)url.toURI().getSchemeSpecificPart(), (String)"!"), (String)"file:");
    }

    private static void disableUpdateChecksOnEveryPlugin() {
        for (Plugin plugin : Plugin.getAllPlugins()) {
            plugin.setMyGlobalOption("noUpdateChecks", "true");
        }
    }

    private static void resetCustomPluginList(Collection<Plugin> customPlugins) {
        if (customPlugins != null) {
            for (Plugin plugin : customPlugins) {
                Plugin.removeCustomPlugin((Plugin)plugin);
            }
        }
    }

    static {
        priorityNameToValueMap.put("high", 1);
        priorityNameToValueMap.put("medium", 2);
        priorityNameToValueMap.put("low", 3);
        priorityNameToValueMap.put("experimental", 4);
        DEFAULT_PRIORITY = 2;
    }

    private static class FindbugsTask
    implements Callable<Object> {
        private final FindBugs2 engine;

        public FindbugsTask(FindBugs2 engine) {
            this.engine = engine;
        }

        @Override
        public Object call() {
            try {
                this.engine.execute();
                Object var1_1 = null;
                return var1_1;
            }
            catch (IOException | InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.engine.dispose();
            }
        }
    }
}

