/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.sonar.api.Plugin;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.plugins.findbugs.FindbugsConfiguration;
import org.sonar.plugins.findbugs.FindbugsExecutor;
import org.sonar.plugins.findbugs.FindbugsProfileExporter;
import org.sonar.plugins.findbugs.FindbugsProfileImporter;
import org.sonar.plugins.findbugs.FindbugsSensor;
import org.sonar.plugins.findbugs.profiles.FindbugsContribProfile;
import org.sonar.plugins.findbugs.profiles.FindbugsProfile;
import org.sonar.plugins.findbugs.profiles.FindbugsSecurityAuditProfile;
import org.sonar.plugins.findbugs.profiles.FindbugsSecurityJspProfile;
import org.sonar.plugins.findbugs.profiles.FindbugsSecurityMinimalProfile;
import org.sonar.plugins.findbugs.resource.ByteCodeResourceLocator;
import org.sonar.plugins.findbugs.rules.FbContribRulesDefinition;
import org.sonar.plugins.findbugs.rules.FindSecurityBugsJspRulesDefinition;
import org.sonar.plugins.findbugs.rules.FindSecurityBugsRulesDefinition;
import org.sonar.plugins.findbugs.rules.FindbugsRulesDefinition;

public class FindbugsPlugin
implements Plugin {
    public static final String[] SUPPORTED_JVM_LANGUAGES = new String[]{"java", "jsp", "scala", "clojure"};
    public static final String[] SUPPORTED_JVM_LANGUAGES_EXTENSIONS = new String[]{"java", "jsp", "scala", "clj"};

    public static FilePredicate[] getSupportedLanguagesFilePredicate(FilePredicates pred) {
        return Arrays.stream(SUPPORTED_JVM_LANGUAGES).map(s -> pred.hasLanguage(s)).collect(Collectors.toList()).toArray(new FilePredicate[SUPPORTED_JVM_LANGUAGES.length]);
    }

    public void define(Plugin.Context context) {
        context.addExtensions(FindbugsConfiguration.getPropertyDefinitions());
        context.addExtensions(Arrays.asList(FindbugsSensor.class, FindbugsProfileExporter.class, FindbugsProfileImporter.class, FindbugsConfiguration.class, FindbugsExecutor.class, FindbugsProfile.class, FindbugsContribProfile.class, FindbugsSecurityAuditProfile.class, FindbugsSecurityMinimalProfile.class, FindbugsSecurityJspProfile.class, FindbugsRulesDefinition.class, FbContribRulesDefinition.class, FindSecurityBugsRulesDefinition.class, FindSecurityBugsJspRulesDefinition.class, ByteCodeResourceLocator.class));
    }
}

