/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Writer;
import java.util.stream.Collectors;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.findbugs.FindbugsPlugin;
import org.sonar.plugins.findbugs.xml.Bug;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;
import org.sonar.plugins.findbugs.xml.Match;

public class FindbugsProfileExporter
extends ProfileExporter {
    public FindbugsProfileExporter() {
        super("findbugs", "FindBugs");
        this.setSupportedLanguages(FindbugsPlugin.SUPPORTED_JVM_LANGUAGES);
        this.setMimeType("application/xml");
    }

    public void exportProfile(RulesProfile profile, Writer writer) {
        try {
            FindBugsFilter filter = FindbugsProfileExporter.buildFindbugsFilter(profile.getActiveRules().stream().filter(activeRule -> activeRule.getRepositoryKey().contains("findbugs") || activeRule.getRepositoryKey().contains("findsecbugs") || activeRule.getRepositoryKey().contains("fb-contrib")).collect(Collectors.toList()));
            XStream xstream = FindBugsFilter.createXStream();
            writer.append(xstream.toXML((Object)filter));
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the Findbugs profile : " + profile, (Throwable)e);
        }
    }

    public static FindBugsFilter buildFindbugsFilter(Iterable<ActiveRule> activeRules) {
        FindBugsFilter root = new FindBugsFilter();
        for (ActiveRule activeRule : activeRules) {
            String repoKey = activeRule.getRepositoryKey();
            if (!repoKey.contains("findsecbugs") && !repoKey.contains("findbugs") && !repoKey.contains("fb-contrib")) continue;
            Match child = new Match();
            child.setBug(new Bug(activeRule.getConfigKey()));
            root.addMatch(child);
        }
        return root;
    }
}

