/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.google.common.collect.Iterables;
import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.findbugs.FindbugsCategory;
import org.sonar.plugins.findbugs.FindbugsLevelUtils;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;

@ScannerSide
@ServerSide
@ExtensionPoint
public class FindbugsProfileImporter {
    private final RuleFinder ruleFinder;
    private static final Logger LOGGER = Loggers.get(FindbugsProfileImporter.class);

    public FindbugsProfileImporter(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public void importProfile(Reader findbugsConf, BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile qualityProfile) {
        try {
            XStream xStream = FindBugsFilter.createXStream();
            FindBugsFilter filter = (FindBugsFilter)xStream.fromXML(findbugsConf);
            this.activateRulesByCategory(qualityProfile, filter);
            this.activateRulesByCode(qualityProfile, filter);
            this.activateRulesByPattern(qualityProfile, filter);
        }
        catch (Exception e) {
            String errorMessage = "The Findbugs configuration file is not valid";
            LOGGER.error(errorMessage, (Throwable)e);
        }
    }

    private void activateRulesByPattern(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, FindBugsFilter filter) {
        for (Map.Entry<String, String> patternLevel : filter.getPatternLevels(new FindbugsLevelUtils()).entrySet()) {
            Rule rule = this.ruleFinder.findByKey("findbugs", patternLevel.getKey());
            if (rule == null && (rule = this.ruleFinder.findByKey("fb-contrib", patternLevel.getKey())) == null && (rule = this.ruleFinder.findByKey("findsecbugs", patternLevel.getKey())) == null) {
                rule = this.ruleFinder.findByKey("findsecbugs-jsp", patternLevel.getKey());
            }
            if (rule != null) {
                this.activateRule(profile, rule, patternLevel.getValue());
                continue;
            }
            LOGGER.warn("Unable to activate unknown rule : '" + patternLevel.getKey() + "'");
        }
    }

    private void activateRulesByCode(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, FindBugsFilter filter) {
        for (Map.Entry<String, String> codeLevel : filter.getCodeLevels(new FindbugsLevelUtils()).entrySet()) {
            boolean someRulesHaveBeenActivated = false;
            for (Rule rule : this.rules()) {
                if (!rule.getKey().equals(codeLevel.getKey()) && !StringUtils.startsWith((String)rule.getKey(), (String)(codeLevel.getKey() + "_"))) continue;
                someRulesHaveBeenActivated = true;
                this.activateRule(profile, rule, codeLevel.getValue());
            }
            if (someRulesHaveBeenActivated) continue;
            LOGGER.warn("Unable to find any rules associated to code  : '" + codeLevel.getKey() + "'");
        }
    }

    private void activateRulesByCategory(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, FindBugsFilter filter) {
        for (Map.Entry<String, String> categoryLevel : filter.getCategoryLevels(new FindbugsLevelUtils()).entrySet()) {
            boolean someRulesHaveBeenActivated = false;
            String sonarCateg = FindbugsCategory.findbugsToSonar(categoryLevel.getKey());
            for (Rule rule : this.rules()) {
                if (sonarCateg == null || !rule.getName().startsWith(sonarCateg)) continue;
                someRulesHaveBeenActivated = true;
                this.activateRule(profile, rule, categoryLevel.getValue());
            }
            if (someRulesHaveBeenActivated) continue;
            LOGGER.warn("Unable to find any rules associated to category  : '" + categoryLevel.getKey() + "'");
        }
    }

    private void activateRule(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, Rule rule, @Nullable String severity) {
        if (rule.isEnabled().booleanValue()) {
            BuiltInQualityProfilesDefinition.NewBuiltInActiveRule r = profile.activateRule(rule.getRepositoryKey(), rule.getKey());
            if (severity == null) {
                r.overrideSeverity(FindbugsProfileImporter.getSeverityFromPriority(rule.getSeverity()));
            } else {
                r.overrideSeverity(severity);
            }
        }
    }

    private static String getSeverityFromPriority(RulePriority priority) {
        switch (priority) {
            case INFO: {
                return "INFO";
            }
            case MINOR: {
                return "MINOR";
            }
            case MAJOR: {
                return "MAJOR";
            }
            case CRITICAL: {
                return "CRITICAL";
            }
            case BLOCKER: {
                return "BLOCKER";
            }
        }
        return Severity.defaultSeverity();
    }

    private Iterable<Rule> rules() {
        return Iterables.concat((Iterable)this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("findbugs")), (Iterable)this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("fb-contrib")), (Iterable)this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("findsecbugs")), (Iterable)this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("findsecbugs-jsp")));
    }
}

