/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.plugins.findbugs.FindbugsExecutor;
import org.sonar.plugins.findbugs.FindbugsPlugin;
import org.sonar.plugins.findbugs.ReportedBug;
import org.sonar.plugins.findbugs.resource.ByteCodeResourceLocator;
import org.sonar.plugins.findbugs.resource.ClassMetadataLoadingException;
import org.sonar.plugins.findbugs.resource.SmapParser;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class FindbugsSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(FindbugsSensor.class);
    public static final String[] REPOS = new String[]{"findbugs", "fb-contrib", "findsecbugs", "findsecbugs-jsp"};
    private List<String> repositories = new ArrayList<String>();
    private ActiveRules activeRules;
    private FindbugsExecutor executor;
    private final JavaResourceLocator javaResourceLocator;
    private final ByteCodeResourceLocator byteCodeResourceLocator;
    private final FileSystem fs;
    private final SensorContext sensorContext;
    protected final File classMappingFile;
    protected PrintWriter classMappingWriter;

    public FindbugsSensor(ActiveRules activeRules, SensorContext sensorContext, FindbugsExecutor executor, JavaResourceLocator javaResourceLocator, FileSystem fs, ByteCodeResourceLocator byteCodeResourceLocator) {
        this.activeRules = activeRules;
        this.sensorContext = sensorContext;
        this.executor = executor;
        this.javaResourceLocator = javaResourceLocator;
        this.byteCodeResourceLocator = byteCodeResourceLocator;
        this.fs = fs;
        this.registerRepositories(REPOS);
        this.classMappingFile = new File(fs.workDir(), "class-mapping.csv");
        try {
            this.classMappingWriter = new PrintWriter(new FileOutputStream(this.classMappingFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void registerRepositories(String ... repos) {
        Collections.addAll(this.repositories, repos);
    }

    private boolean hasActiveRules(String repoSubstring) {
        return this.activeRules.findAll().stream().anyMatch(activeRule -> activeRule.ruleKey().repository().contains(repoSubstring));
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    private boolean hasActiveFindbugsRules() {
        return this.hasActiveRules("findbugs");
    }

    private boolean hasActiveFbContribRules() {
        return this.hasActiveRules("fb-contrib");
    }

    private boolean hasActiveFindSecBugsRules() {
        return this.hasActiveRules("findsecbugs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext context) {
        if (!(this.hasActiveFindbugsRules() || this.hasActiveFbContribRules() || this.hasActiveFindSecBugsRules())) {
            return;
        }
        Collection<ReportedBug> collection = this.executor.execute(this.hasActiveFbContribRules(), this.hasActiveFindSecBugsRules());
        try {
            for (ReportedBug bugInstance : collection) {
                try {
                    String repoKey;
                    ActiveRule rule = null;
                    Iterator<String> iterator = this.getRepositories().iterator();
                    while (iterator.hasNext() && (rule = this.activeRules.findByInternalKey(repoKey = iterator.next(), bugInstance.getType())) == null) {
                    }
                    if (rule == null) {
                        LOG.warn("Findbugs rule '{}' is not active in Sonar.", (Object)bugInstance.getType());
                        continue;
                    }
                    String className = bugInstance.getClassName();
                    String sourceFile = bugInstance.getSourceFile();
                    String longMessage = bugInstance.getMessage();
                    int line = bugInstance.getStartLine();
                    InputFile resource = this.byteCodeResourceLocator.findSourceFile(sourceFile, this.fs);
                    if (resource != null) {
                        this.insertIssue(rule, resource, line, longMessage, bugInstance);
                        continue;
                    }
                    File classFile = this.findOriginalClassForBug(bugInstance.getClassFile());
                    if (classFile == null) {
                        LOG.warn("Unable to find the class " + bugInstance.getClassName());
                        continue;
                    }
                    if (classFile != null) {
                        try {
                            SmapParser.SmapLocation location = this.byteCodeResourceLocator.extractSmapLocation(className, line, classFile);
                            if (location != null) {
                                if (!location.isPrimaryFile) continue;
                                resource = this.byteCodeResourceLocator.findSourceFile(location.fileInfo.path, this.fs);
                                if (resource != null) {
                                    this.insertIssue(rule, resource, location.line, longMessage, bugInstance);
                                    continue;
                                }
                            } else {
                                resource = this.byteCodeResourceLocator.findTemplateFile(className, this.fs);
                                if (resource != null) {
                                    this.insertIssue(rule, resource, line, longMessage, bugInstance);
                                    continue;
                                }
                            }
                        }
                        catch (ClassMetadataLoadingException e) {
                            LOG.warn("Failed to load the class file metadata", (Throwable)e);
                        }
                    }
                    LOG.warn("The class '" + className + "' could not be matched to its original source file. It might be a dynamically generated class.");
                }
                catch (Exception e) {
                    String bugInstanceDebug = String.format("[BugInstance type=%s, class=%s, line=%s]", bugInstance.getType(), bugInstance.getClassName(), bugInstance.getStartLine());
                    LOG.warn("An error occurs while processing the bug instance " + bugInstanceDebug, (Throwable)e);
                }
            }
        }
        finally {
            if (this.classMappingWriter != null) {
                this.classMappingWriter.flush();
                this.classMappingWriter.close();
            }
        }
    }

    protected void insertIssue(ActiveRule rule, InputFile resource, int line, String message, ReportedBug bugInstance) {
        NewIssue newIssue = this.sensorContext.newIssue().forRule(rule.ruleKey());
        NewIssueLocation location = newIssue.newLocation().on((InputComponent)resource).at(resource.selectLine(line > 0 ? line : 1)).message(message);
        newIssue.at(location);
        newIssue.save();
        this.writeDebugMappingToFile(bugInstance.getClassName(), bugInstance.getStartLine(), resource.relativePath(), line);
    }

    protected void writeDebugMappingToFile(String classFile, int classFileLine, String sourceFile, int sourceFileLine) {
        if (this.classMappingWriter != null) {
            this.classMappingWriter.println(classFile + ":" + classFileLine + "," + sourceFile + ":" + sourceFileLine);
        }
    }

    private File findOriginalClassForBug(String className) {
        String sourceFile = this.byteCodeResourceLocator.findSourceFileKeyByClassName(className, this.javaResourceLocator);
        if (sourceFile == null) {
            return null;
        }
        return new File(sourceFile);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(FindbugsPlugin.SUPPORTED_JVM_LANGUAGES);
        descriptor.name("FindBugs Sensor");
    }
}

