/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMInputCursor;

class FindbugsXmlReportParser {
    private final File findbugsXmlReport;
    private final String findbugsXmlReportPath;

    public FindbugsXmlReportParser(File findbugsXmlReport) {
        this.findbugsXmlReport = findbugsXmlReport;
        this.findbugsXmlReportPath = findbugsXmlReport.getAbsolutePath();
        if (!findbugsXmlReport.exists()) {
            throw new IllegalStateException("The findbugs XML report can't be found at '" + this.findbugsXmlReportPath + "'");
        }
    }

    public List<XmlBugInstance> getBugInstances() {
        ArrayList result = Lists.newArrayList();
        try {
            SMInputFactory inf = new SMInputFactory(XMLInputFactory.newInstance());
            SMInputCursor cursor = inf.rootElementCursor(this.findbugsXmlReport).advance();
            SMInputCursor bugInstanceCursor = cursor.childElementCursor("BugInstance").advance();
            while (bugInstanceCursor.asEvent() != null) {
                XmlBugInstance xmlBugInstance = new XmlBugInstance();
                xmlBugInstance.type = bugInstanceCursor.getAttrValue("type");
                xmlBugInstance.longMessage = "";
                result.add(xmlBugInstance);
                ImmutableList.Builder lines = ImmutableList.builder();
                SMInputCursor bugInstanceChildCursor = bugInstanceCursor.childElementCursor().advance();
                while (bugInstanceChildCursor.asEvent() != null) {
                    String nodeName = bugInstanceChildCursor.getLocalName();
                    if ("LongMessage".equals(nodeName)) {
                        xmlBugInstance.longMessage = bugInstanceChildCursor.collectDescendantText();
                    } else if ("SourceLine".equals(nodeName)) {
                        XmlSourceLineAnnotation xmlSourceLineAnnotation = new XmlSourceLineAnnotation();
                        xmlSourceLineAnnotation.parseStart(bugInstanceChildCursor.getAttrValue("start"));
                        xmlSourceLineAnnotation.parseEnd(bugInstanceChildCursor.getAttrValue("end"));
                        xmlSourceLineAnnotation.parsePrimary(bugInstanceChildCursor.getAttrValue("primary"));
                        xmlSourceLineAnnotation.className = bugInstanceChildCursor.getAttrValue("classname");
                        lines.add((Object)xmlSourceLineAnnotation);
                    }
                    bugInstanceChildCursor.advance();
                }
                xmlBugInstance.sourceLines = (List)lines.build();
                bugInstanceCursor.advance();
            }
            cursor.getStreamReader().closeCompletely();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to parse the Findbugs XML Report '" + this.findbugsXmlReportPath + "'", e);
        }
        return result;
    }

    public static class XmlSourceLineAnnotation {
        private boolean primary;
        private Integer start;
        private Integer end;
        @VisibleForTesting
        protected String className;

        public void parseStart(String attrValue) {
            try {
                this.start = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException e) {
                this.start = null;
            }
        }

        public void parseEnd(String attrValue) {
            try {
                this.end = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException e) {
                this.end = null;
            }
        }

        public void parsePrimary(String attrValue) {
            this.primary = Boolean.parseBoolean(attrValue);
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSonarJavaFileKey() {
            if (this.className.indexOf(36) > -1) {
                return this.className.substring(0, this.className.indexOf(36));
            }
            return this.className;
        }
    }

    public static class XmlBugInstance {
        private String type;
        private String longMessage;
        private List<XmlSourceLineAnnotation> sourceLines;

        public String getType() {
            return this.type;
        }

        public String getLongMessage() {
            return this.longMessage;
        }

        @CheckForNull
        public XmlSourceLineAnnotation getPrimarySourceLine() {
            for (XmlSourceLineAnnotation sourceLine : this.sourceLines) {
                if (!sourceLine.isPrimary()) continue;
                return sourceLine;
            }
            return this.sourceLines.isEmpty() ? null : this.sourceLines.get(0);
        }
    }
}

