/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.plugins.findbugs.FindbugsPlugin;

public class ReportedBug {
    private final String type;
    private final String message;
    private final String className;
    private final int startLine;
    private final String sourceFile;
    private final String classFile;
    private static final Pattern SOURCE_FILE_PATTERN = ReportedBug.createSourceFilePattern();

    public ReportedBug(BugInstance bugInstance) {
        this.type = bugInstance.getType();
        this.message = bugInstance.getMessageWithoutPrefix();
        this.className = bugInstance.getPrimarySourceLineAnnotation().getClassName();
        this.startLine = bugInstance.getPrimarySourceLineAnnotation().getStartLine();
        this.sourceFile = bugInstance.getPrimarySourceLineAnnotation().getSourcePath();
        Matcher m = SOURCE_FILE_PATTERN.matcher(this.sourceFile);
        this.classFile = m.find() ? m.group(1).replaceAll("/", ".") : this.className;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getClassName() {
        return this.className;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getClassFile() {
        return this.classFile;
    }

    private static Pattern createSourceFilePattern() {
        StringBuffer extensions = new StringBuffer();
        for (int i = 0; i < FindbugsPlugin.SUPPORTED_JVM_LANGUAGES_EXTENSIONS.length; ++i) {
            String extension = FindbugsPlugin.SUPPORTED_JVM_LANGUAGES_EXTENSIONS[i];
            extensions.append(extension);
            if (i >= FindbugsPlugin.SUPPORTED_JVM_LANGUAGES_EXTENSIONS.length - 1) continue;
            extensions.append("|");
        }
        String pattern = "^(.*)\\.(" + extensions + ")$";
        return Pattern.compile(pattern);
    }
}

