/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.findbugs.resource.DebugExtensionExtractor;
import org.sonar.plugins.findbugs.resource.JasperUtils;
import org.sonar.plugins.findbugs.resource.SmapParser;
import org.sonar.plugins.java.api.JavaResourceLocator;
import shaded.io.IOUtils;

@ScannerSide
public class ByteCodeResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(ByteCodeResourceLocator.class);
    private static final String[] SOURCE_DIRECTORIES = new String[]{"src/main/java", "src/main/webapp", "src/main/resources", "src", "src/java", "app", "src/main/scala"};

    public String findSourceFileKeyByClassName(String className, JavaResourceLocator javaResourceLocator) {
        URI classFile;
        InputFile input = javaResourceLocator.findResourceByClassName(className);
        if (input != null && (classFile = input.uri()) != null && "file".equals(classFile.getScheme())) {
            return new File(classFile).getAbsolutePath();
        }
        String fileName = className.replaceAll("\\.", "/") + ".class";
        Collection classPathEntries = javaResourceLocator.classpath();
        for (File classPathEntry : classPathEntries) {
            File potentialLocation;
            if (!classPathEntry.isDirectory() || !(potentialLocation = new File(classPathEntry, fileName)).exists()) continue;
            return potentialLocation.getPath();
        }
        return null;
    }

    public InputFile findSourceFile(String sourceFile, FileSystem fs) {
        return this.buildInputFile(sourceFile, fs);
    }

    public InputFile findTemplateFile(String className, FileSystem fs) {
        ArrayList<String> potentialJspFilenames = new ArrayList<String>();
        if (className.startsWith("jsp_servlet")) {
            String jspFile = className.substring(11).replaceFirst("\\.__([^\\.]+)$", "/$1\\.jsp").replace("._", "/");
            potentialJspFilenames.add(jspFile);
        }
        if (className.endsWith("_jsp")) {
            String jspFileFromClass = JasperUtils.decodeJspClassName(className);
            potentialJspFilenames.add(jspFileFromClass);
            for (String packageName : Arrays.asList("jsp/", "org/apache/jsp/")) {
                if (!jspFileFromClass.startsWith(packageName)) continue;
                potentialJspFilenames.add(jspFileFromClass.substring(packageName.length()));
            }
        }
        for (String jspFilename : potentialJspFilenames) {
            InputFile file = this.buildInputFile(jspFilename, fs);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private InputFile buildInputFile(String fileName, FileSystem fs) {
        for (String sourceDir : SOURCE_DIRECTORIES) {
            Iterable files = fs.inputFiles(fs.predicates().hasRelativePath(sourceDir + "/" + fileName));
            Iterator iterator = files.iterator();
            if (!iterator.hasNext()) continue;
            InputFile f = (InputFile)iterator.next();
            return f;
        }
        for (InputFile f : fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN))) {
            if (!f.relativePath().endsWith(fileName)) continue;
            return f;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public SmapParser.SmapLocation extractSmapLocation(String className, int originalLine, File classFile) {
        try (FileInputStream in = new FileInputStream(classFile);){
            DebugExtensionExtractor debug = new DebugExtensionExtractor();
            String smap = debug.getDebugExtFromClass(in);
            if (smap != null) {
                SmapParser.SmapLocation smapLocation = this.getJspLineNumberFromSmap(smap, originalLine);
                return smapLocation;
            }
        }
        catch (IOException e) {
            LOG.warn("An error occurs while opening classfile : {}", (Object)classFile.getPath());
        }
        LOG.debug("No smap file found for the class: " + className);
        File smapFile = new File(classFile.getPath() + ".smap");
        if (!smapFile.exists()) {
            LOG.debug("No smap mapping found.");
            return null;
        }
        try (FileInputStream smapInputStream = new FileInputStream(smapFile);){
            SmapParser.SmapLocation smapLocation = this.getJspLineNumberFromSmap(IOUtils.toString(smapInputStream), originalLine);
            return smapLocation;
        }
        catch (IOException e) {
            LOG.debug("Unable to open smap file : {} ({})", (Object)smapFile.getAbsolutePath(), (Object)e.getMessage());
            return null;
        }
    }

    private SmapParser.SmapLocation getJspLineNumberFromSmap(String smap, Integer originalLine) throws IOException {
        SmapParser parser = new SmapParser(smap);
        return parser.getSmapLocation(originalLine);
    }
}

