/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.findbugs.FindbugsLevelUtils;
import org.sonar.plugins.findbugs.xml.Bug;
import org.sonar.plugins.findbugs.xml.ClassFilter;
import org.sonar.plugins.findbugs.xml.FieldFilter;
import org.sonar.plugins.findbugs.xml.LocalFilter;
import org.sonar.plugins.findbugs.xml.Match;
import org.sonar.plugins.findbugs.xml.MethodFilter;
import org.sonar.plugins.findbugs.xml.OrFilter;
import org.sonar.plugins.findbugs.xml.PackageFilter;
import org.sonar.plugins.findbugs.xml.Priority;

@XStreamAlias(value="FindBugsFilter")
public class FindBugsFilter {
    private static final String PATTERN_SEPARATOR = ",";
    private static final String CODE_SEPARATOR = ",";
    private static final String CATEGORY_SEPARATOR = ",";
    private static final Class[] ALL_XSTREAM_TYPES = new Class[]{Bug.class, ClassFilter.class, FieldFilter.class, FindBugsFilter.class, LocalFilter.class, Match.class, MethodFilter.class, OrFilter.class, PackageFilter.class, Priority.class};
    @XStreamImplicit
    private List<Match> matchs = new ArrayList<Match>();

    public String toXml() {
        XStream xstream = FindBugsFilter.createXStream();
        return xstream.toXML((Object)this);
    }

    public List<Match> getMatchs() {
        return this.matchs;
    }

    public List<Match> getChildren() {
        return this.matchs;
    }

    public void addMatch(Match child) {
        this.matchs.add(child);
    }

    public Map<String, String> getPatternLevels(FindbugsLevelUtils priorityMapper) {
        return this.processMatches(priorityMapper, new PatternSplitter());
    }

    public Map<String, String> getCodeLevels(FindbugsLevelUtils priorityMapper) {
        return this.processMatches(priorityMapper, new CodeSplitter());
    }

    public Map<String, String> getCategoryLevels(FindbugsLevelUtils priorityMapper) {
        return this.processMatches(priorityMapper, new CategorySplitter());
    }

    private static String getRuleSeverity(Priority priority, FindbugsLevelUtils priorityMapper) {
        return priority != null ? priorityMapper.from(priority.getValue()) : null;
    }

    private Map<String, String> processMatches(FindbugsLevelUtils priorityMapper, BugInfoSplitter splitter) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Match child : this.getChildren()) {
            if (child.getOrs() != null) {
                for (OrFilter orFilter : child.getOrs()) {
                    FindBugsFilter.completeLevels(result, orFilter.getBugs(), child.getPriority(), priorityMapper, splitter);
                }
            }
            if (child.getBug() == null) continue;
            FindBugsFilter.completeLevels(result, Arrays.asList(child.getBug()), child.getPriority(), priorityMapper, splitter);
        }
        return result;
    }

    private static void completeLevels(Map<String, String> result, List<Bug> bugs, Priority priority, FindbugsLevelUtils priorityMapper, BugInfoSplitter splitter) {
        if (bugs == null) {
            return;
        }
        String severity = FindBugsFilter.getRuleSeverity(priority, priorityMapper);
        for (Bug bug : bugs) {
            String[] splitted;
            String varToSplit = splitter.getVar(bug);
            if (StringUtils.isBlank((String)varToSplit)) continue;
            for (String code : splitted = StringUtils.split((String)varToSplit, (String)splitter.getSeparator())) {
                FindBugsFilter.mapRuleSeverity(result, severity, code);
            }
        }
    }

    private static void mapRuleSeverity(Map<String, String> severityByRule, String severity, String key) {
        if (severityByRule.containsKey(key) && severityByRule.get(key) != null) {
            severityByRule.put(key, FindBugsFilter.getHighestSeverity(severityByRule.get(key), severity));
        } else {
            severityByRule.put(key, severity);
        }
    }

    private static String getHighestSeverity(String s1, String s2) {
        if (s1.equals(s2) || "MAJOR".equals(s1) && "INFO".equals(s2) || "BLOCKER".equals(s1)) {
            return s1;
        }
        return s2;
    }

    public static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.setClassLoader(FindBugsFilter.class.getClassLoader());
        for (Class modelClass : ALL_XSTREAM_TYPES) {
            xstream.processAnnotations(modelClass);
            xstream.allowTypeHierarchy(modelClass);
        }
        return xstream;
    }

    private static class CategorySplitter
    implements BugInfoSplitter {
        private CategorySplitter() {
        }

        @Override
        public String getSeparator() {
            return ",";
        }

        @Override
        public String getVar(Bug bug) {
            return bug.getCategory();
        }
    }

    private static class CodeSplitter
    implements BugInfoSplitter {
        private CodeSplitter() {
        }

        @Override
        public String getSeparator() {
            return ",";
        }

        @Override
        public String getVar(Bug bug) {
            return bug.getCode();
        }
    }

    private static class PatternSplitter
    implements BugInfoSplitter {
        private PatternSplitter() {
        }

        @Override
        public String getSeparator() {
            return ",";
        }

        @Override
        public String getVar(Bug bug) {
            return bug.getPattern();
        }
    }

    private static interface BugInfoSplitter {
        public String getVar(Bug var1);

        public String getSeparator();
    }
}

