/*
 * Decompiled with CFR 0.152.
 */
package shaded.channel;

import java.io.IOException;
import java.io.Reader;
import shaded.channel.Channel;
import shaded.channel.CodeReader;
import shaded.channel.CodeReaderFilter;

public final class ChannelCodeReaderFilter<O>
extends CodeReaderFilter<O> {
    private Channel<O>[] channels = new Channel[0];
    private CodeReader internalCodeReader;

    public ChannelCodeReaderFilter(Channel<O> ... channels) {
        this.channels = channels;
    }

    public ChannelCodeReaderFilter(O output, Channel<O> ... channels) {
        super(output);
        this.channels = channels;
    }

    @Override
    public void setReader(Reader reader) {
        super.setReader(reader);
        this.internalCodeReader = new CodeReader(reader, this.getConfiguration());
    }

    @Override
    public int read(char[] filteredBuffer, int offset, int length) throws IOException {
        if (this.internalCodeReader.peek() == -1) {
            return -1;
        }
        int initialOffset = offset;
        while (offset < filteredBuffer.length && this.internalCodeReader.peek() != -1) {
            boolean consumed = false;
            for (Channel channel : this.channels) {
                if (!channel.consume(this.internalCodeReader, this.getOutput())) continue;
                consumed = true;
                break;
            }
            if (consumed) continue;
            int charRead = this.internalCodeReader.pop();
            filteredBuffer[offset++] = (char)charRead;
        }
        return offset - initialOffset;
    }
}

